/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.collector.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import shaded.org.hawkular.apm.api.model.config.txn.TransactionConfig;

public class FilterProcessor {
    private String transaction;
    private TransactionConfig config;
    private List<Predicate<String>> inclusions = new ArrayList<Predicate<String>>();
    private List<Predicate<String>> exclusions = new ArrayList<Predicate<String>>();

    protected FilterProcessor() {
    }

    public FilterProcessor(String transaction, TransactionConfig config) {
        this.transaction = transaction;
        this.config = config;
        this.init();
    }

    protected void init() {
        int i;
        for (i = 0; i < this.config.getFilter().getInclusions().size(); ++i) {
            this.inclusions.add(Pattern.compile(this.config.getFilter().getInclusions().get(i)).asPredicate());
        }
        for (i = 0; i < this.config.getFilter().getExclusions().size(); ++i) {
            this.exclusions.add(Pattern.compile(this.config.getFilter().getExclusions().get(i)).asPredicate());
        }
    }

    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public TransactionConfig getConfig() {
        return this.config;
    }

    public void setConfig(TransactionConfig config) {
        this.config = config;
    }

    public boolean isIncludeAll() {
        return this.inclusions.isEmpty();
    }

    public boolean isIncluded(String endpoint) {
        for (int i = 0; i < this.inclusions.size(); ++i) {
            if (!this.inclusions.get(i).test(endpoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(String endpoint) {
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!this.exclusions.get(i).test(endpoint)) continue;
            return true;
        }
        return false;
    }
}

