/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.config.service.rest.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import shaded.com.fasterxml.jackson.core.type.TypeReference;
import shaded.org.hawkular.apm.api.logging.Logger;
import shaded.org.hawkular.apm.api.model.config.CollectorConfiguration;
import shaded.org.hawkular.apm.api.model.config.txn.ConfigMessage;
import shaded.org.hawkular.apm.api.model.config.txn.TransactionConfig;
import shaded.org.hawkular.apm.api.model.config.txn.TransactionSummary;
import shaded.org.hawkular.apm.api.services.ConfigurationLoader;
import shaded.org.hawkular.apm.api.services.ConfigurationService;
import shaded.org.hawkular.apm.api.utils.PropertyUtil;
import shaded.org.hawkular.apm.client.api.rest.AbstractRESTClient;

public class ConfigurationServiceRESTClient
extends AbstractRESTClient
implements ConfigurationService {
    private static final Logger log = Logger.getLogger(ConfigurationServiceRESTClient.class.getName());
    private static final TypeReference<CollectorConfiguration> COLLECTOR_CONFIGURATION_TYPE_REFERENCE = new TypeReference<CollectorConfiguration>(){};
    private static final TypeReference<TransactionConfig> TXN_CONFIG_TYPE_REFERENCE = new TypeReference<TransactionConfig>(){};
    private static final TypeReference<List<TransactionSummary>> TXN_SUMMARY_LIST = new TypeReference<List<TransactionSummary>>(){};
    private static final TypeReference<Map<String, TransactionConfig>> TXN_CONFIG_MAP = new TypeReference<Map<String, TransactionConfig>>(){};
    private static final TypeReference<List<ConfigMessage>> CONFIG_MESSAGE_LIST = new TypeReference<List<ConfigMessage>>(){};

    public ConfigurationServiceRESTClient() {
        super("HAWKULAR_APM_URI_SERVICES");
    }

    public ConfigurationServiceRESTClient(String username, String password, String url) {
        super(username, password, url);
    }

    @Override
    public CollectorConfiguration getCollector(String tenantId, String type, String host, String server) {
        String url;
        CollectorConfiguration cc;
        String parameters;
        if (PropertyUtil.getProperty("HAWKULAR_APM_CONFIG") != null) {
            CollectorConfiguration ret = ConfigurationLoader.getConfiguration(type);
            if (log.isLoggable(Logger.Level.FINEST)) {
                try {
                    log.finest("Collector configuration [local] = " + (ret == null ? null : mapper.writeValueAsString(ret)));
                }
                catch (Throwable t) {
                    log.finest("Collector configuration [local]: failed to serialize as json: " + t);
                }
            }
            return ret;
        }
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder parametersBuilder = new StringBuilder();
        if (null != type) {
            parametersBuilder.append("type=").append(type).append("&");
        }
        if (null != host) {
            parametersBuilder.append("host=").append(host).append("&");
        }
        if (null != server) {
            parametersBuilder.append("server=").append(server).append("&");
        }
        if ((parameters = parametersBuilder.toString()).length() > 0) {
            parameters = parameters.substring(0, parameters.length() - 1);
        }
        if ((cc = this.getResultsForUrl(tenantId, COLLECTOR_CONFIGURATION_TYPE_REFERENCE, url = "config/collector?" + parameters, new Object[0])) == null) {
            log.warning("Unable to obtain APM configuration from " + this.getUrl(url) + ", will retry ...");
        }
        return cc;
    }

    @Override
    public List<ConfigMessage> setTransaction(String tenantId, String name, TransactionConfig config) {
        return this.withJsonPayloadAndResults("PUT", tenantId, this.getUrl("config/transaction/full/%s", name), config, connection -> this.parseResultsIntoJson((HttpURLConnection)connection, CONFIG_MESSAGE_LIST));
    }

    @Override
    public List<ConfigMessage> setTransactions(String tenantId, Map<String, TransactionConfig> configs) {
        return this.withJsonPayloadAndResults("POST", tenantId, this.getUrl("config/transaction/full"), configs, connection -> this.parseResultsIntoJson((HttpURLConnection)connection, CONFIG_MESSAGE_LIST));
    }

    @Override
    public List<ConfigMessage> validateTransaction(TransactionConfig config) {
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        return this.withJsonPayloadAndResults("POST", null, this.getUrl("config/transaction/validate"), config, connection -> this.parseResultsIntoJson((HttpURLConnection)connection, CONFIG_MESSAGE_LIST));
    }

    @Override
    public TransactionConfig getTransaction(String tenantId, String name) {
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        String url = "config/transaction/full/%s";
        return this.getResultsForUrl(tenantId, TXN_CONFIG_TYPE_REFERENCE, url, name);
    }

    @Override
    public List<TransactionSummary> getTransactionSummaries(String tenantId) {
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        String url = "config/transaction/summary";
        return this.getResultsForUrl(tenantId, TXN_SUMMARY_LIST, url, new Object[0]);
    }

    @Override
    public Map<String, TransactionConfig> getTransactions(String tenantId, long updated) {
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        String url = "config/transaction/full?updated=%d";
        return this.getResultsForUrl(tenantId, TXN_CONFIG_MAP, url, updated);
    }

    @Override
    public void removeTransaction(String tenantId, String name) {
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return;
        }
        URL url = this.getUrl("config/transaction/full/%s", name);
        this.withContext(tenantId, url, connection -> {
            try {
                connection.setRequestMethod("DELETE");
                if (connection.getResponseCode() == 200) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest(String.format("Transaction [%s] removed", name));
                    }
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.warning("Failed to remove transaction: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.log(Logger.Level.SEVERE, String.format("Failed to remove transaction [%s]", name), e);
            }
            return null;
        });
    }

    @Override
    public void clear(String tenantId) {
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return;
        }
        this.clear(tenantId, "config");
    }
}

