/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.trace;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.InteractionNode;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.NodeType;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=InteractionNode.class)})
@ApiModel(parent=Node.class, subTypes={InteractionNode.class}, discriminator="type")
public abstract class ContainerNode
extends Node {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Node> nodes = new ArrayList<Node>();

    public ContainerNode(NodeType type) {
        super(type);
    }

    public ContainerNode(NodeType type, String uri) {
        super(type, uri);
    }

    @Override
    public boolean containerNode() {
        return true;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    @Override
    protected void includeProperties(Set<Property> allProperties) {
        super.includeProperties(allProperties);
        this.nodes.forEach(n -> n.includeProperties(allProperties));
    }

    @Override
    protected long overallEndTime() {
        long ret = super.overallEndTime();
        for (Node child : this.nodes) {
            long childEndTime = child.overallEndTime();
            if (childEndTime <= ret) continue;
            ret = childEndTime;
        }
        return ret;
    }

    @Override
    protected void findCorrelatedNodes(CorrelationIdentifier cid, Set<Node> nodes) {
        super.findCorrelatedNodes(cid, nodes);
        for (Node child : this.getNodes()) {
            child.findCorrelatedNodes(cid, nodes);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerNode other = (ContainerNode)obj;
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }
}

