/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.services.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.analytics.CommunicationSummaryStatistics;

public class CommunicationSummaryTreeBuilder {
    private static final Logger log = Logger.getLogger(CommunicationSummaryTreeBuilder.class.getName());

    public static Collection<CommunicationSummaryStatistics> buildCommunicationSummaryTree(Collection<CommunicationSummaryStatistics> nodes) {
        HashMap<String, CommunicationSummaryStatistics> nodeMap = new HashMap<String, CommunicationSummaryStatistics>();
        for (CommunicationSummaryStatistics css : nodes) {
            nodeMap.put(css.getId(), css);
        }
        Collection<CommunicationSummaryStatistics> rootNodes = CommunicationSummaryTreeBuilder.getRootCommunicationSummaryNodes(nodeMap);
        if (rootNodes != null) {
            ArrayList<CommunicationSummaryStatistics> ret = new ArrayList<CommunicationSummaryStatistics>();
            for (CommunicationSummaryStatistics css : rootNodes) {
                CommunicationSummaryStatistics rootNode = new CommunicationSummaryStatistics(css);
                CommunicationSummaryTreeBuilder.initCommunicationSummaryTreeNode(rootNode, nodeMap, new HashSet<String>(Collections.singleton(rootNode.getId())));
                ret.add(rootNode);
            }
            return ret;
        }
        return null;
    }

    protected static void initCommunicationSummaryTreeNode(CommunicationSummaryStatistics node, Map<String, CommunicationSummaryStatistics> nodeMap, Set<String> usedIds) {
        for (String id : node.getOutbound().keySet()) {
            if (usedIds.contains(id)) continue;
            if (!nodeMap.containsKey(id)) {
                log.severe("Node missing for id = " + id);
            }
            CommunicationSummaryStatistics copy = new CommunicationSummaryStatistics(nodeMap.get(id));
            CommunicationSummaryStatistics.ConnectionStatistics cs = node.getOutbound().get(id);
            cs.setNode(copy);
            usedIds.add(id);
            CommunicationSummaryTreeBuilder.initCommunicationSummaryTreeNode(copy, nodeMap, usedIds);
        }
    }

    protected static Collection<CommunicationSummaryStatistics> getRootCommunicationSummaryNodes(Map<String, CommunicationSummaryStatistics> nodeMap) {
        HashMap<String, CommunicationSummaryStatistics> nodeMapCopy = new HashMap<String, CommunicationSummaryStatistics>(nodeMap);
        for (CommunicationSummaryStatistics css : nodeMap.values()) {
            for (String linkId : css.getOutbound().keySet()) {
                nodeMapCopy.remove(linkId);
            }
        }
        return nodeMapCopy.values();
    }
}

