/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hawkular.apm.api.logging.Logger;

public class PropertyUtil {
    private static final Logger LOG = Logger.getLogger(PropertyUtil.class.getName());
    public static final String HAWKULAR_TENANT = "HAWKULAR_TENANT";
    public static final String HAWKULAR_URI = "HAWKULAR_URI";
    public static final String HAWKULAR_USERNAME = "HAWKULAR_USERNAME";
    public static final String HAWKULAR_PASSWORD = "HAWKULAR_PASSWORD";
    public static final String HAWKULAR_APM_URI = "HAWKULAR_APM_URI";
    public static final String HAWKULAR_APM_URI_SERVICES = "HAWKULAR_APM_URI_SERVICES";
    public static final String HAWKULAR_APM_URI_PUBLISHER = "HAWKULAR_APM_URI_PUBLISHER";
    public static final String HAWKULAR_APM_USERNAME = "HAWKULAR_APM_USERNAME";
    public static final String HAWKULAR_APM_PASSWORD = "HAWKULAR_APM_PASSWORD";
    public static final String HAWKULAR_APM_CONFIG_RETRY_INTERVAL = "HAWKULAR_APM_CONFIG_RETRY_INTERVAL";
    public static final String HAWKULAR_APM_CONFIG_REFRESH = "HAWKULAR_APM_CONFIG_REFRESH";
    public static final String HAWKULAR_APM_LOG_LEVEL = "HAWKULAR_APM_LOG_LEVEL";
    public static final String HAWKULAR_APM_LOG_JUL = "HAWKULAR_APM_LOG_JUL";
    public static final String HAWKULAR_APM_COLLECTOR_BATCHSIZE = "HAWKULAR_APM_COLLECTOR_BATCHSIZE";
    public static final String HAWKULAR_APM_COLLECTOR_BATCHTIME = "HAWKULAR_APM_COLLECTOR_BATCHTIME";
    public static final String HAWKULAR_APM_COLLECTOR_BATCHTHREADS = "HAWKULAR_APM_COLLECTOR_BATCHTHREADS";
    public static final String HAWKULAR_APM_AGENT_STATE_EXPIRY_INTERVAL = "HAWKULAR_APM_AGENT_STATE_EXPIRY_INTERVAL";
    public static final String HAWKULAR_APM_PROCESSOR_MAX_RETRY_COUNT = "HAWKULAR_APM_PROCESSOR_MAX_RETRY_COUNT";
    public static final String HAWKULAR_APM_PROCESSOR_RETRY_DELAY = "HAWKULAR_APM_PROCESSOR_RETRY_DELAY";
    public static final String HAWKULAR_APM_PROCESSOR_LAST_RETRY_DELAY = "HAWKULAR_APM_PROCESSOR_LAST_RETRY_DELAY";
    public static final String HAWKULAR_APM_KAFKA_POLLING_INTERVAL = "HAWKULAR_APM_KAFKA_POLLING_INTERVAL";
    public static final String HAWKULAR_APM_KAFKA_MAX_POLL_RECORDS = "HAWKULAR_APM_KAFKA_MAX_POLL_RECORDS";
    public static final String HAWKULAR_APM_KAFKA_PRODUCER_RETRIES = "HAWKULAR_APM_KAFKA_PRODUCER_RETRIES";
    public static final String HAWKULAR_APM_KAFKA_CONSUMER_AUTO_COMMIT_INTERVAL = "HAWKULAR_APM_KAFKA_CONSUMER_AUTO_COMMIT_INTERVAL";
    public static final String HAWKULAR_APM_KAFKA_CONSUMER_SESSION_TIMEOUT = "HAWKULAR_APM_KAFKA_CONSUMER_SESSION_TIMEOUT";
    public static final String HAWKULAR_APM_CORS_ALLOWED_ORIGINS = "HAWKULAR_APM_CORS_ALLOWED_ORIGINS";
    public static final String HAWKULAR_APM_CORS_ACCESS_CONTROL_ALLOW_HEADERS = "HAWKULAR_APM_CORS_ACCESS_CONTROL_ALLOW_HEADERS";
    public static final String KAFKA_PREFIX = "kafka:";
    private static final String ENV_HOSTNAME = "HOSTNAME";
    public static final String HAWKULAR_APM_SERVICE_NAME = "HAWKULAR_APM_SERVICE_NAME";
    public static final String OPENSHIFT_BUILD_NAME = "OPENSHIFT_BUILD_NAME";
    public static final String OPENSHIFT_BUILD_NAMESPACE = "OPENSHIFT_BUILD_NAMESPACE";
    private static final String ENV_KAFKA_ZOOKEEPER = "KAFKA_ZOOKEEPER";
    private static String hostName = System.getenv("HOSTNAME");
    private static String hostAddress;

    public static boolean hasProperty(String name) {
        return PropertyUtil.getProperty(name) != null;
    }

    public static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    public static String getProperty(String name, String def) {
        String ret = System.getProperty(name, System.getenv(name));
        if (ret != null) {
            return ret;
        }
        return def;
    }

    public static Integer getPropertyAsInteger(String name) {
        return PropertyUtil.getPropertyAsInteger(name, null);
    }

    public static Integer getPropertyAsInteger(String name, Integer def) {
        String value = PropertyUtil.getProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.log(Logger.Level.WARNING, "Failed to convert property value '" + value + "' to integer", e);
            }
        }
        return def;
    }

    public static boolean getPropertyAsBoolean(String name) {
        String value = PropertyUtil.getProperty(name);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static String getHostName() {
        return hostName;
    }

    public static String getHostAddress() {
        return hostAddress;
    }

    public static String getKafkaZookeeper() {
        return System.getenv(ENV_KAFKA_ZOOKEEPER);
    }

    static {
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOG.severe("Unable to determine host name");
            }
        }
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.severe("Unable to determine host address");
        }
    }
}

