/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.analytics;

import java.util.HashMap;
import java.util.Map;

public class CommunicationSummaryStatistics {
    private String id;
    private long minimumDuration;
    private long averageDuration;
    private long maximumDuration;
    private long count;
    private int severity = 0;
    private String uri;
    private String operation;
    private String serviceName;
    private Map<String, ConnectionStatistics> outbound = new HashMap<String, ConnectionStatistics>();

    public CommunicationSummaryStatistics() {
    }

    public CommunicationSummaryStatistics(CommunicationSummaryStatistics node) {
        this.id = node.id;
        this.minimumDuration = node.minimumDuration;
        this.averageDuration = node.averageDuration;
        this.maximumDuration = node.maximumDuration;
        this.count = node.count;
        this.severity = node.severity;
        this.uri = node.uri;
        this.operation = node.operation;
        this.serviceName = node.getServiceName();
        for (Map.Entry<String, ConnectionStatistics> entry : node.getOutbound().entrySet()) {
            this.outbound.put(entry.getKey(), new ConnectionStatistics(entry.getValue()));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getMinimumDuration() {
        return this.minimumDuration;
    }

    public void setMinimumDuration(long minimumDuration) {
        this.minimumDuration = minimumDuration;
    }

    public long getAverageDuration() {
        return this.averageDuration;
    }

    public void setAverageDuration(long averageDuration) {
        this.averageDuration = averageDuration;
    }

    public long getMaximumDuration() {
        return this.maximumDuration;
    }

    public void setMaximumDuration(long maximumDuration) {
        this.maximumDuration = maximumDuration;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Map<String, ConnectionStatistics> getOutbound() {
        return this.outbound;
    }

    public void setOutbound(Map<String, ConnectionStatistics> outbound) {
        this.outbound = outbound;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String toString() {
        return "CommunicationSummaryStatistics [id=" + this.id + ", minimumDuration=" + this.minimumDuration + ", averageDuration=" + this.averageDuration + ", maximumDuration=" + this.maximumDuration + ", count=" + this.count + ", severity=" + this.severity + ", uri=" + this.uri + ", operation=" + this.operation + " , serviceName=" + this.serviceName + ", outbound=" + this.outbound + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.averageDuration ^ this.averageDuration >>> 32);
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (int)(this.maximumDuration ^ this.maximumDuration >>> 32);
        result = 31 * result + (int)(this.minimumDuration ^ this.minimumDuration >>> 32);
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.outbound == null ? 0 : this.outbound.hashCode());
        result = 31 * result + this.severity;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommunicationSummaryStatistics other = (CommunicationSummaryStatistics)obj;
        if (this.averageDuration != other.averageDuration) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.maximumDuration != other.maximumDuration) {
            return false;
        }
        if (this.minimumDuration != other.minimumDuration) {
            return false;
        }
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        if (this.outbound == null ? other.outbound != null : !this.outbound.equals(other.outbound)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public static class ConnectionStatistics {
        private long minimumLatency;
        private long averageLatency;
        private long maximumLatency;
        private long count;
        private int severity = 0;
        private CommunicationSummaryStatistics node;

        public ConnectionStatistics() {
        }

        public ConnectionStatistics(ConnectionStatistics cs) {
            this.minimumLatency = cs.minimumLatency;
            this.averageLatency = cs.averageLatency;
            this.maximumLatency = cs.maximumLatency;
            this.count = cs.count;
            this.severity = cs.severity;
            if (cs.node != null) {
                this.node = new CommunicationSummaryStatistics(cs.node);
            }
        }

        public long getMinimumLatency() {
            return this.minimumLatency;
        }

        public void setMinimumLatency(long minimumLatency) {
            this.minimumLatency = minimumLatency;
        }

        public long getAverageLatency() {
            return this.averageLatency;
        }

        public void setAverageLatency(long averageLatency) {
            this.averageLatency = averageLatency;
        }

        public long getMaximumLatency() {
            return this.maximumLatency;
        }

        public void setMaximumLatency(long maximumLatency) {
            this.maximumLatency = maximumLatency;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public int getSeverity() {
            return this.severity;
        }

        public void setSeverity(int severity) {
            this.severity = severity;
        }

        public CommunicationSummaryStatistics getNode() {
            return this.node;
        }

        public void setNode(CommunicationSummaryStatistics node) {
            this.node = node;
        }

        public String toString() {
            return "ConnectionStatistics [minimumLatency=" + this.minimumLatency + ", averageLatency=" + this.averageLatency + ", maximumLatency=" + this.maximumLatency + ", count=" + this.count + ", severity=" + this.severity + ", node=" + this.node + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.averageLatency ^ this.averageLatency >>> 32);
            result = 31 * result + (int)(this.count ^ this.count >>> 32);
            result = 31 * result + (int)(this.maximumLatency ^ this.maximumLatency >>> 32);
            result = 31 * result + (int)(this.minimumLatency ^ this.minimumLatency >>> 32);
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + this.severity;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionStatistics other = (ConnectionStatistics)obj;
            if (this.averageLatency != other.averageLatency) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            if (this.maximumLatency != other.maximumLatency) {
                return false;
            }
            if (this.minimumLatency != other.minimumLatency) {
                return false;
            }
            if (this.node == null ? other.node != null : !this.node.equals(other.node)) {
                return false;
            }
            return this.severity == other.severity;
        }
    }
}

