/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.internal.actions.ProcessorActionHandler;
import org.hawkular.apm.api.internal.actions.ProcessorActionHandlerFactory;
import org.hawkular.apm.api.model.config.txn.ConfigMessage;
import org.hawkular.apm.api.model.config.txn.Processor;
import org.hawkular.apm.api.model.config.txn.ProcessorAction;
import org.hawkular.apm.api.model.config.txn.TransactionConfig;
import org.hawkular.apm.api.services.ConfigurationService;

public abstract class AbstractConfigurationService
implements ConfigurationService {
    private static final String NO_FILTERS = "No inclusion or exclusion filters have been defined";

    @Override
    public List<ConfigMessage> validateTransaction(TransactionConfig config) {
        ArrayList<ConfigMessage> messages = new ArrayList<ConfigMessage>();
        if (config.getFilter() == null || config.getFilter().getInclusions().isEmpty() && config.getFilter().getInclusions().isEmpty()) {
            ConfigMessage cm = new ConfigMessage();
            cm.setMessage(NO_FILTERS);
            messages.add(cm);
        }
        for (Processor processor : config.getProcessors()) {
            for (ProcessorAction action : processor.getActions()) {
                ProcessorActionHandler handler = ProcessorActionHandlerFactory.getHandler(action);
                if (handler == null) continue;
                messages.addAll(handler.init(processor));
            }
        }
        return messages;
    }

    @Override
    public List<ConfigMessage> setTransactions(String tenantId, Map<String, TransactionConfig> configs) throws Exception {
        ArrayList<ConfigMessage> messages = new ArrayList<ConfigMessage>();
        for (Map.Entry<String, TransactionConfig> stringBusinessTxnConfigEntry : configs.entrySet()) {
            messages.addAll(this.setTransaction(tenantId, stringBusinessTxnConfigEntry.getKey(), stringBusinessTxnConfigEntry.getValue()));
        }
        return messages;
    }
}

