/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.internal.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.internal.actions.ExpressionHandler;
import org.hawkular.apm.api.internal.actions.ExpressionHandlerFactory;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.Severity;
import org.hawkular.apm.api.model.config.Direction;
import org.hawkular.apm.api.model.config.txn.ConfigMessage;
import org.hawkular.apm.api.model.config.txn.Processor;
import org.hawkular.apm.api.model.config.txn.ProcessorAction;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;

public abstract class ProcessorActionHandler {
    private static final Logger log = Logger.getLogger(ProcessorActionHandler.class.getName());
    private ProcessorAction action;
    private ExpressionHandler predicate;
    private boolean usesHeaders = false;
    private boolean usesContent = false;

    public ProcessorActionHandler(ProcessorAction action) {
        this.setAction(action);
    }

    public ProcessorAction getAction() {
        return this.action;
    }

    protected void setAction(ProcessorAction action) {
        this.action = action;
    }

    public boolean isUsesHeaders() {
        return this.usesHeaders;
    }

    public void setUsesHeaders(boolean usesHeaders) {
        this.usesHeaders = usesHeaders;
    }

    public boolean isUsesContent() {
        return this.usesContent;
    }

    public void setUsesContent(boolean usesContent) {
        this.usesContent = usesContent;
    }

    public List<ConfigMessage> init(Processor processor) {
        ArrayList<ConfigMessage> configMessages = new ArrayList<ConfigMessage>();
        if (this.action.getPredicate() != null) {
            try {
                this.predicate = ExpressionHandlerFactory.getHandler(this.action.getPredicate());
                this.predicate.init(processor, this.getAction(), true);
                if (!this.isUsesHeaders()) {
                    this.setUsesHeaders(this.predicate.isUsesHeaders());
                }
                if (!this.isUsesContent()) {
                    this.setUsesContent(this.predicate.isUsesContent());
                }
            }
            catch (Throwable t) {
                log.severe("Failed to initialise predicate for action:" + this.action, t);
                ConfigMessage configMessage = new ConfigMessage();
                configMessage.setSeverity(Severity.Error);
                configMessage.setMessage(t.getMessage());
                configMessage.setProcessor(processor.getDescription());
                configMessage.setAction(this.action.getDescription());
                configMessages.add(configMessage);
            }
        }
        return configMessages;
    }

    public boolean process(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.predicate != null) {
            return this.predicate.test(trace, node, direction, headers, values);
        }
        return true;
    }
}

