/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.internal.actions;

import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.internal.actions.ExpressionBasedActionHandler;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.Severity;
import org.hawkular.apm.api.model.config.Direction;
import org.hawkular.apm.api.model.config.txn.AddContentAction;
import org.hawkular.apm.api.model.config.txn.ConfigMessage;
import org.hawkular.apm.api.model.config.txn.Processor;
import org.hawkular.apm.api.model.config.txn.ProcessorAction;
import org.hawkular.apm.api.model.trace.InteractionNode;
import org.hawkular.apm.api.model.trace.Message;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;

public class AddContentActionHandler
extends ExpressionBasedActionHandler {
    private static final Logger log = Logger.getLogger(AddContentActionHandler.class.getName());

    public AddContentActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public List<ConfigMessage> init(Processor processor) {
        List<ConfigMessage> configMessages = super.init(processor);
        AddContentAction action = (AddContentAction)this.getAction();
        if (action.getName() == null || action.getName().trim().isEmpty()) {
            String message = "Name must be specified";
            log.severe(processor.getDescription() + ":" + this.getAction().getDescription() + ":" + message);
            ConfigMessage configMessage = new ConfigMessage();
            configMessage.setSeverity(Severity.Error);
            configMessage.setMessage(message);
            configMessage.setField("name");
            configMessage.setProcessor(processor.getDescription());
            configMessage.setAction(action.getDescription());
            configMessages.add(0, configMessage);
        }
        return configMessages;
    }

    @Override
    public boolean process(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        String value;
        if (super.process(trace, node, direction, headers, values) && (value = this.getValue(trace, node, direction, headers, values)) != null) {
            if (node.interactionNode()) {
                if (direction == Direction.In) {
                    if (((InteractionNode)node).getIn() == null) {
                        ((InteractionNode)node).setIn(new Message());
                    }
                    ((InteractionNode)node).getIn().addContent(((AddContentAction)this.getAction()).getName(), ((AddContentAction)this.getAction()).getType(), value);
                } else {
                    if (((InteractionNode)node).getOut() == null) {
                        ((InteractionNode)node).setOut(new Message());
                    }
                    ((InteractionNode)node).getOut().addContent(((AddContentAction)this.getAction()).getName(), ((AddContentAction)this.getAction()).getType(), value);
                }
                return true;
            }
            log.warning("Attempt to add content to a non-interaction based node type '" + (Object)((Object)node.getType()) + "'");
        }
        return false;
    }
}

