/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.internal.actions;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.api.internal.actions.ExpressionHandler;
import org.hawkular.apm.api.internal.actions.JSONExpressionHandler;
import org.hawkular.apm.api.internal.actions.LiteralExpressionHandler;
import org.hawkular.apm.api.internal.actions.TextExpressionHandler;
import org.hawkular.apm.api.internal.actions.XMLExpressionHandler;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.config.btxn.Expression;
import org.hawkular.apm.api.model.config.btxn.JSONExpression;
import org.hawkular.apm.api.model.config.btxn.LiteralExpression;
import org.hawkular.apm.api.model.config.btxn.TextExpression;
import org.hawkular.apm.api.model.config.btxn.XMLExpression;

public class ExpressionHandlerFactory {
    private static final Logger log = Logger.getLogger(ExpressionHandlerFactory.class.getName());
    private static Map<Class<? extends Expression>, Class<? extends ExpressionHandler>> handlers = new HashMap<Class<? extends Expression>, Class<? extends ExpressionHandler>>();

    public static ExpressionHandler getHandler(Expression expression) {
        ExpressionHandler ret = null;
        Class<? extends ExpressionHandler> cls = handlers.get(expression.getClass());
        if (cls != null) {
            try {
                Constructor<? extends ExpressionHandler> con = cls.getConstructor(Expression.class);
                ret = con.newInstance(expression);
            }
            catch (Exception e) {
                log.log(Logger.Level.SEVERE, "Failed to instantiate handler for expression '" + expression + "'", e);
            }
        }
        return ret;
    }

    static {
        handlers.put(JSONExpression.class, JSONExpressionHandler.class);
        handlers.put(XMLExpression.class, XMLExpressionHandler.class);
        handlers.put(TextExpression.class, TextExpressionHandler.class);
        handlers.put(LiteralExpression.class, LiteralExpressionHandler.class);
    }
}

