/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.analytics;

import com.fasterxml.jackson.annotation.JsonInclude;

public class EndpointInfo {
    @JsonInclude
    private String endpoint;
    @JsonInclude
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String regex;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String uriRegex;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String uriTemplate;

    public EndpointInfo() {
    }

    public EndpointInfo(String endpoint) {
        this.endpoint = endpoint;
    }

    public EndpointInfo(EndpointInfo endpointInfo) {
        this.endpoint = endpointInfo.endpoint;
        this.type = endpointInfo.type;
        this.regex = endpointInfo.regex;
        this.uriRegex = endpointInfo.uriRegex;
        this.uriTemplate = endpointInfo.uriTemplate;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public EndpointInfo setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public EndpointInfo setType(String type) {
        this.type = type;
        return this;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getUriRegex() {
        return this.uriRegex;
    }

    public void setUriRegex(String uriRegex) {
        this.uriRegex = uriRegex;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public boolean metaURI() {
        return this.endpoint != null && (this.endpoint.indexOf("/*/") != -1 || this.endpoint.endsWith("/*") || this.endpoint.indexOf("/*[") != -1);
    }

    public int hashCode() {
        if (this.endpoint != null) {
            return this.endpoint.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EndpointInfo && this.endpoint != null) {
            return this.endpoint.equals(((EndpointInfo)obj).endpoint);
        }
        return false;
    }

    public String toString() {
        return "EndpointInfo [endpoint=" + this.endpoint + ", type=" + this.type + ", regex=" + this.regex + ", uriRegex=" + this.uriRegex + ", uriTemplate=" + this.uriTemplate + "]";
    }
}

