/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.api.rest;

import java.net.HttpURLConnection;
import java.util.Base64;
import org.hawkular.apm.api.services.ServiceStatus;
import org.hawkular.apm.api.utils.PropertyUtil;

public class AbstractRESTClient
implements ServiceStatus {
    private static final String HAWKULAR_TENANT = "Hawkular-Tenant";
    private String username = PropertyUtil.getProperty((String)"HAWKULAR_APM_USERNAME");
    private String password = PropertyUtil.getProperty((String)"HAWKULAR_APM_PASSWORD");
    private String authorization = null;
    private String uri;
    private static final Base64.Encoder encoder = Base64.getEncoder();

    public AbstractRESTClient(String uriProperty) {
        this.uri = PropertyUtil.getProperty((String)uriProperty, (String)PropertyUtil.getProperty((String)"HAWKULAR_APM_URI"));
        if (this.uri != null && !this.uri.isEmpty() && this.uri.charAt(this.uri.length() - 1) != '/') {
            this.uri = this.uri + '/';
        }
    }

    public boolean isAvailable() {
        return this.uri != null && this.uri.startsWith("http");
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId == null) {
            tenantId = PropertyUtil.getProperty((String)"HAWKULAR_TENANT");
        }
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_TENANT, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = encoder.encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }
}

