/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing;

import io.opentracing.APMSpan;
import io.opentracing.APMSpanBuilder;
import io.opentracing.AbstractTracer;
import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.trace.NodeType;
import org.hawkular.apm.client.api.reporter.BatchTraceReporter;
import org.hawkular.apm.client.api.reporter.TraceReporter;
import org.hawkular.apm.client.opentracing.APMTracer;

public abstract class AbstractAPMTracer
extends AbstractTracer {
    private static final Logger log = Logger.getLogger(APMTracer.class.getName());
    private TraceReporter reporter;

    public AbstractAPMTracer() {
        this.reporter = new BatchTraceReporter();
    }

    public AbstractAPMTracer(TraceReporter reporter) {
        this.reporter = reporter;
    }

    APMSpanBuilder createSpanBuilder(String operationName) {
        return new APMSpanBuilder(operationName, this.reporter);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (spanContext instanceof APMSpan) {
            ((APMSpan)spanContext).setInteractionId(UUID.randomUUID().toString(), NodeType.Producer);
        }
        super.inject(spanContext, format, carrier);
    }

    Map<String, Object> getTraceState(SpanContext spanContext) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (spanContext instanceof APMSpan) {
            APMSpan span = (APMSpan)spanContext;
            if (span.getInteractionId() != null) {
                ret.put("HWKAPMID", span.getInteractionId());
            } else {
                log.warning("No id available to include in trace state for context = " + spanContext);
            }
            if (span.getTraceContext().getBusinessTransaction() == null && span.getTags().containsKey("transaction")) {
                span.getTraceContext().setBusinessTransaction(span.getTags().get("transaction").toString());
            }
            if (span.getTraceContext().getBusinessTransaction() != null) {
                ret.put("HWKAPMTXN", span.getTraceContext().getBusinessTransaction());
            }
            if (span.getTraceContext().getReportingLevel() != null) {
                ret.put("HWKAPMLEVEL", span.getTraceContext().getReportingLevel());
            }
        }
        return ret;
    }
}

