/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.opentracing;

import io.opentracing.APMSpan;
import java.util.Map;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.client.opentracing.NodeBuilder;
import org.hawkular.apm.client.opentracing.NodeProcessor;
import org.hawkular.apm.client.opentracing.TagUtil;
import org.hawkular.apm.client.opentracing.TraceContext;

public class DefaultNodeProcessor
implements NodeProcessor {
    @Override
    public void process(TraceContext context, APMSpan span, NodeBuilder nodeBuilder) {
        for (Map.Entry entry : span.getTags().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            if (TagUtil.isUriKey((String)entry.getKey())) {
                nodeBuilder.setUri(TagUtil.getUriPath(entry.getValue().toString()));
                String type = TagUtil.getTypeFromUriKey((String)entry.getKey());
                nodeBuilder.setEndpointType(type);
                nodeBuilder.setComponentType(type);
                continue;
            }
            if (((String)entry.getKey()).equals("component")) {
                nodeBuilder.setComponentType(entry.getValue().toString());
                continue;
            }
            if (((String)entry.getKey()).contains("transaction")) {
                if (context.getBusinessTransaction() != null) continue;
                context.setBusinessTransaction(entry.getValue().toString());
                continue;
            }
            nodeBuilder.addProperty(new Property((String)entry.getKey(), entry.getValue().toString()));
        }
    }
}

