/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.opentracing;

import io.opentracing.APMSpan;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.hawkular.apm.api.model.events.EndpointRef;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.client.api.reporter.TraceReporter;
import org.hawkular.apm.client.opentracing.DefaultNodeProcessor;
import org.hawkular.apm.client.opentracing.NodeBuilder;
import org.hawkular.apm.client.opentracing.NodeProcessor;
import org.hawkular.apm.client.opentracing.TagUtil;

public class TraceContext {
    private Trace trace;
    private APMSpan topSpan;
    private NodeBuilder rootNode;
    private String businessTransaction;
    private String reportingLevel;
    private AtomicInteger nodeCount = new AtomicInteger(0);
    private TraceReporter reporter;
    private static List<NodeProcessor> nodeProcessors = new ArrayList<NodeProcessor>();

    public TraceContext(APMSpan topSpan, NodeBuilder rootNode, long startTime, TraceReporter reporter) {
        this.topSpan = topSpan;
        this.rootNode = rootNode;
        this.reporter = reporter;
        this.trace = new Trace();
        this.trace.setId(UUID.randomUUID().toString());
        this.trace.setStartTime(startTime);
        this.trace.setHostName(PropertyUtil.getHostName());
        this.trace.setHostAddress(PropertyUtil.getHostAddress());
        rootNode.setNodePath(String.format("%s:0", this.trace.getId()));
    }

    public void startProcessingNode() {
        this.nodeCount.incrementAndGet();
    }

    public void endProcessingNode() {
        if (this.nodeCount.decrementAndGet() == 0 && this.reporter != null) {
            Node node = this.rootNode.build();
            this.trace.setBusinessTransaction(this.getBusinessTransaction());
            this.trace.getNodes().add(node);
            this.reporter.report(this.trace);
        }
    }

    public String getBusinessTransaction() {
        return this.businessTransaction;
    }

    public void setBusinessTransaction(String businessTransaction) {
        this.businessTransaction = businessTransaction;
    }

    public String getReportingLevel() {
        return this.reportingLevel;
    }

    public void setReportingLevel(String reportingLevel) {
        this.reportingLevel = reportingLevel;
    }

    public List<NodeProcessor> getNodeProcessors() {
        return nodeProcessors;
    }

    public APMSpan getTopSpan() {
        return this.topSpan;
    }

    public EndpointRef getSourceEndpoint() {
        return new EndpointRef(TagUtil.getUriPath(this.topSpan.getTags()), this.topSpan.getOperationName(), false);
    }

    static {
        nodeProcessors.add(new DefaultNodeProcessor());
    }
}

