/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing;

import io.opentracing.APMSpanBuilder;
import io.opentracing.AbstractSpan;
import io.opentracing.AbstractSpanBuilder;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.events.EndpointRef;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.NodeType;
import org.hawkular.apm.api.utils.TimeUtil;
import org.hawkular.apm.client.api.reporter.TraceReporter;
import org.hawkular.apm.client.opentracing.NodeBuilder;
import org.hawkular.apm.client.opentracing.TraceContext;

public class APMSpan
extends AbstractSpan {
    private static final Logger log = Logger.getLogger((String)APMSpan.class.getName());
    private TraceContext traceContext;
    private NodeBuilder nodeBuilder;
    private String nodePath;
    private String interactionId;

    public APMSpan(APMSpanBuilder builder, TraceReporter reporter) {
        super(builder.operationName, builder.start);
        this.init(builder, reporter);
    }

    protected void init(APMSpanBuilder builder, TraceReporter reporter) {
        for (AbstractSpanBuilder.Reference ref : builder.references) {
            if (ref.getReferenceType() == "child_of") {
                this.initChildOf(builder, reporter, ref);
            } else if (ref.getReferenceType() == "follows_from") {
                this.initFollowsFrom(builder, reporter, ref);
            }
            if (this.nodeBuilder == null) continue;
            break;
        }
        if (this.nodeBuilder == null) {
            this.initTopLevelState(this, reporter);
        }
        this.nodePath = this.nodeBuilder.getNodePath();
        this.traceContext.startProcessingNode();
    }

    protected void initTopLevelState(APMSpan topSpan, TraceReporter reporter) {
        this.nodeBuilder = new NodeBuilder();
        this.traceContext = new TraceContext(topSpan, this.nodeBuilder, reporter);
    }

    protected void initChildOf(APMSpanBuilder builder, TraceReporter reporter, AbstractSpanBuilder.Reference ref) {
        if (ref.getReferredTo() instanceof APMSpan) {
            APMSpan parent = (APMSpan)ref.getReferredTo();
            if (parent.getNodeBuilder() != null) {
                this.nodeBuilder = new NodeBuilder(parent.getNodeBuilder());
                this.traceContext = parent.traceContext;
                if (parent.getTags().containsKey("transaction") && this.traceContext.getTransaction() == null) {
                    this.traceContext.setTransaction(parent.getTags().get("transaction").toString());
                }
            }
        } else if (ref.getReferredTo() instanceof APMSpanBuilder) {
            APMSpanBuilder parentBuilder = (APMSpanBuilder)ref.getReferredTo();
            this.initTopLevelState(this, reporter);
            if (parentBuilder.getState().containsKey("HWKAPMID")) {
                this.setInteractionId(parentBuilder.getState().get("HWKAPMID").toString(), NodeType.Consumer);
                if (parentBuilder.getState().containsKey("HWKAPMTRACEID")) {
                    this.traceContext.setTraceId(parentBuilder.getState().get("HWKAPMTRACEID").toString());
                } else {
                    log.severe("Trace id has not been propagated");
                }
                if (parentBuilder.getState().containsKey("HWKAPMTXN")) {
                    this.traceContext.setTransaction(parentBuilder.getState().get("HWKAPMTXN").toString());
                }
                if (parentBuilder.getState().containsKey("HWKAPMLEVEL")) {
                    this.traceContext.setReportingLevel(parentBuilder.getState().get("HWKAPMLEVEL").toString());
                }
            } else {
                this.getNodeBuilder().setNodeType(NodeType.Consumer);
            }
        } else {
            log.severe("Unknown parent type = " + ref.getReferredTo());
        }
    }

    protected void initFollowsFrom(APMSpanBuilder builder, TraceReporter reporter, AbstractSpanBuilder.Reference ref) {
        if (ref.getReferredTo() instanceof APMSpan) {
            APMSpan referenced = (APMSpan)ref.getReferredTo();
            this.initTopLevelState(referenced.getTraceContext().getTopSpan(), reporter);
            String nodeId = referenced.getNodePath();
            this.getNodeBuilder().addCorrelationId(new CorrelationIdentifier(CorrelationIdentifier.Scope.CausedBy, nodeId));
            this.getNodeBuilder().setNodeType(NodeType.Consumer);
            this.getNodeBuilder().setEndpointType(null);
            EndpointRef epref = referenced.getTraceContext().getSourceEndpoint();
            this.getNodeBuilder().setUri(epref.getUri());
            this.getNodeBuilder().setOperation(epref.getOperation());
            this.getNodeBuilder().setTimestamp(TimeUtil.toMicros((Instant)builder.start));
            this.nodeBuilder = new NodeBuilder(this.getNodeBuilder());
            this.traceContext.setTraceId(referenced.getTraceContext().getTraceId());
            this.traceContext.setTransaction(referenced.getTraceContext().getTransaction());
            this.traceContext.setReportingLevel(referenced.getTraceContext().getReportingLevel());
        }
    }

    protected void setInteractionId(String id, NodeType nodeType) {
        this.interactionId = id;
        this.getNodeBuilder().setNodeType(nodeType);
        this.getNodeBuilder().addCorrelationId(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
    }

    protected String getInteractionId() {
        return this.interactionId;
    }

    protected String getNodePath() {
        return this.nodePath;
    }

    public void finish() {
        if (!this.isCompleted()) {
            super.finish();
            this.completeNode();
        }
    }

    public void finish(long finishMicros) {
        if (!this.isCompleted()) {
            super.finish(finishMicros);
            this.completeNode();
        }
    }

    private void completeNode() {
        if (this.nodeBuilder == null) {
            return;
        }
        this.nodeBuilder.setOperation(this.getOperationName());
        this.nodeBuilder.setTimestamp(TimeUtil.toMicros((Instant)this.getStart()));
        this.nodeBuilder.setDuration(TimeUnit.NANOSECONDS.toMicros(this.getDuration().toNanos()));
        this.traceContext.getNodeProcessors().forEach(np -> np.process(this.traceContext, this, this.nodeBuilder));
        this.traceContext.endProcessingNode();
        this.nodeBuilder = null;
    }

    private boolean isCompleted() {
        return this.nodeBuilder == null;
    }

    protected NodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    protected TraceContext getTraceContext() {
        return this.traceContext;
    }
}

