/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.config.service.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.config.CollectorConfiguration;
import org.hawkular.apm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.apm.api.model.config.btxn.BusinessTxnSummary;
import org.hawkular.apm.api.model.config.btxn.ConfigMessage;
import org.hawkular.apm.api.services.ConfigurationLoader;
import org.hawkular.apm.api.services.ConfigurationService;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.client.api.rest.AbstractRESTClient;

public class ConfigurationServiceRESTClient
extends AbstractRESTClient
implements ConfigurationService {
    private static final Logger log = Logger.getLogger((String)ConfigurationServiceRESTClient.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTxnSummary>> BTXN_SUMMARY_LIST = new TypeReference<List<BusinessTxnSummary>>(){};
    private static final TypeReference<Map<String, BusinessTxnConfig>> BUSINESS_TXN_MAP = new TypeReference<Map<String, BusinessTxnConfig>>(){};
    private static final TypeReference<List<ConfigMessage>> CONFIG_MESSAGE_LIST = new TypeReference<List<ConfigMessage>>(){};

    public ConfigurationServiceRESTClient() {
        super("HAWKULAR_APM_URI_SERVICES");
    }

    public CollectorConfiguration getCollector(String tenantId, String type, String host, String server) {
        block23: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Get collector configuration: tenantId=[" + tenantId + "] type=[" + type + "] host=[" + host + "] server=[" + server + "]");
            }
            if (PropertyUtil.getProperty((String)"HAWKULAR_APM_CONFIG") != null) {
                CollectorConfiguration ret = ConfigurationLoader.getConfiguration((String)type);
                if (log.isLoggable(Logger.Level.FINEST)) {
                    try {
                        log.finest("Collector configuration [local] = " + (ret == null ? null : mapper.writeValueAsString((Object)ret)));
                    }
                    catch (Throwable t) {
                        log.finest("Collector configuration [local]: failed to serialize as json: " + t);
                    }
                }
                return ret;
            }
            if (!this.isAvailable()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Configuration Service is not enabled");
                }
                return null;
            }
            StringBuilder builder = new StringBuilder().append(this.getUri()).append("hawkular/apm/config/collector");
            if (host != null) {
                builder.append("?host=");
                builder.append(host);
            }
            if (server != null) {
                if (host == null) {
                    builder.append('?');
                } else {
                    builder.append('&');
                }
                builder.append("server=");
                builder.append(server);
            }
            if (type != null) {
                if (host == null && server == null) {
                    builder.append('?');
                } else {
                    builder.append('&');
                }
                builder.append("type=");
                builder.append(type);
            }
            try {
                int len;
                URL url = new URL(builder.toString());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                connection.setAllowUserInteraction(false);
                connection.setRequestProperty("Content-Type", "application/json");
                this.addHeaders(connection, tenantId);
                InputStream is = connection.getInputStream();
                StringBuilder resp = new StringBuilder();
                byte[] b = new byte[10000];
                while ((len = is.read(b)) != -1) {
                    resp.append(new String(b, 0, len));
                }
                is.close();
                if (connection.getResponseCode() == 200) {
                    try {
                        CollectorConfiguration ret = (CollectorConfiguration)mapper.readValue(resp.toString(), CollectorConfiguration.class);
                        if (log.isLoggable(Logger.Level.FINEST)) {
                            log.finest("Collector configuration [remote] = " + (ret == null ? null : mapper.writeValueAsString((Object)ret)));
                        }
                        return ret;
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Failed to get collector configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Logger.Level.FINE)) break block23;
                log.log(Logger.Level.FINE, "Failed to send 'get' collector configuration request", (Throwable)e);
            }
        }
        return null;
    }

    public List<ConfigMessage> setBusinessTransaction(String tenantId, String name, BusinessTxnConfig config) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Set busioess transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "] config=[" + config + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.getUri()).append("hawkular/apm/config/businesstxn/full/").append(name);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            OutputStream os = connection.getOutputStream();
            os.write(mapper.writeValueAsBytes((Object)config));
            os.flush();
            os.close();
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Set business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (!resp.toString().trim().isEmpty()) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CONFIG_MESSAGE_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else {
                log.severe("Failed to set business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to set business transaction  [" + name + "] configuration", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<ConfigMessage> setBusinessTransactions(String tenantId, Map<String, BusinessTxnConfig> configs) throws Exception {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Set busioess transaction configurations: tenantId=[" + tenantId + "] configs=[" + configs + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.getUri()).append("hawkular/apm/config/businesstxn/full");
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            OutputStream os = connection.getOutputStream();
            os.write(mapper.writeValueAsBytes(configs));
            os.flush();
            os.close();
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Set business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (!resp.toString().trim().isEmpty()) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CONFIG_MESSAGE_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else {
                log.severe("Failed to set business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to set business transaction configurations", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<ConfigMessage> validateBusinessTransaction(BusinessTxnConfig config) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Validate busioess transaction configuration: config=[" + config + "]");
        }
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder builder = new StringBuilder().append(this.getUri()).append("hawkular/apm/config/businesstxn/validate");
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, null);
            OutputStream os = connection.getOutputStream();
            os.write(mapper.writeValueAsBytes((Object)config));
            os.flush();
            os.close();
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Validate business transaction configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (!resp.toString().trim().isEmpty()) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CONFIG_MESSAGE_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else {
                log.severe("Failed to validate business transaction configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to validate business transaction configuration", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public BusinessTxnConfig getBusinessTransaction(String tenantId, String name) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "]");
        }
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder builder = new StringBuilder().append(this.getUri()).append("hawkular/apm/config/businesstxn/full/").append(name);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (!resp.toString().trim().isEmpty()) {
                    try {
                        return (BusinessTxnConfig)mapper.readValue(resp.toString(), BusinessTxnConfig.class);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get business transaction [" + name + "] configuration", (Throwable)e);
        }
        return null;
    }

    public List<BusinessTxnSummary> getBusinessTransactionSummaries(String tenantId) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction summaries: tenantId=[" + tenantId + "]");
        }
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder builder = new StringBuilder().append(this.getUri()).append("hawkular/apm/config/businesstxn/summary");
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (!resp.toString().trim().isEmpty()) {
                    try {
                        return (List)mapper.readValue(resp.toString(), BTXN_SUMMARY_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction summaries: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get business transaction summaries", (Throwable)e);
        }
        return null;
    }

    public Map<String, BusinessTxnConfig> getBusinessTransactions(String tenantId, long updated) {
        block13: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Get business transaction configurations: tenantId=[" + tenantId + "] updated=[" + updated + "]");
            }
            if (!this.isAvailable()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Configuration Service is not enabled");
                }
                return null;
            }
            StringBuilder builder = new StringBuilder().append(this.getUri()).append("hawkular/apm/config/businesstxn/full?updated=").append(updated);
            try {
                int len;
                URL url = new URL(builder.toString());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                connection.setAllowUserInteraction(false);
                connection.setRequestProperty("Content-Type", "application/json");
                this.addHeaders(connection, tenantId);
                InputStream is = connection.getInputStream();
                StringBuilder resp = new StringBuilder();
                byte[] b = new byte[10000];
                while ((len = is.read(b)) != -1) {
                    resp.append(new String(b, 0, len));
                }
                is.close();
                if (connection.getResponseCode() == 200) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Returned json=[" + resp.toString() + "]");
                    }
                    if (!resp.toString().trim().isEmpty()) {
                        try {
                            return (Map)mapper.readValue(resp.toString(), BUSINESS_TXN_MAP);
                        }
                        catch (Throwable t) {
                            log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                        }
                    }
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Failed to get business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Logger.Level.FINE)) break block13;
                log.log(Logger.Level.FINE, "Failed to get business transaction configurations", (Throwable)e);
            }
        }
        return null;
    }

    public void removeBusinessTransaction(String tenantId, String name) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Update busioess transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "]]");
        }
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return;
        }
        StringBuilder builder = new StringBuilder().append(this.getUri()).append("hawkular/apm/config/businesstxn/full/").append(name);
        try {
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            connection.getResponseCode();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Remove business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to remove business transaction  [" + name + "] configuration", (Throwable)e);
        }
    }

    public void clear(String tenantId) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Clear business transaction configurations: tenantId=[" + tenantId + "]");
        }
        if (!this.isAvailable()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return;
        }
        try {
            URL url = new URL(this.getUri() + "hawkular/apm/config");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Business transaction configs cleared");
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to clear business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'clear' business transaction config request", (Throwable)e);
        }
    }
}

