/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.nodedetails;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.api.model.trace.Component;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.InteractionNode;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.NodeType;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;

public class NodeDetailsDeriver
extends AbstractProcessor<Trace, NodeDetails> {
    private static final Logger log = Logger.getLogger(NodeDetailsDeriver.class.getName());

    public NodeDetailsDeriver() {
        super(Processor.ProcessorType.OneToMany);
    }

    public List<NodeDetails> processOneToMany(String tenantId, Trace item) throws RetryAttemptException {
        ArrayList<NodeDetails> ret = new ArrayList<NodeDetails>();
        long baseTime = 0L;
        if (!item.getNodes().isEmpty()) {
            baseTime = ((Node)item.getNodes().get(0)).getBaseTime();
        }
        this.deriveNodeDetails(item, baseTime, item.getNodes(), ret);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("NodeDetailsDeriver [" + ret.size() + "] ret=" + ret);
        }
        return ret;
    }

    protected void deriveNodeDetails(Trace trace, long baseTime, List<Node> nodes, List<NodeDetails> rts) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            boolean ignoreNode = false;
            boolean ignoreChildNodes = false;
            if (n.getClass() == Consumer.class && ((Consumer)n).getEndpointType() == null) {
                ignoreNode = true;
            } else if (n.getClass() == Producer.class && ((Producer)n).getEndpointType() == null) {
                ignoreNode = true;
                ignoreChildNodes = true;
            }
            if (!ignoreNode) {
                long diffns = n.getBaseTime() - baseTime;
                long diffms = TimeUnit.MILLISECONDS.convert(diffns, TimeUnit.NANOSECONDS);
                NodeDetails nd = new NodeDetails();
                nd.setId(trace.getId() + "-" + rts.size());
                nd.setBusinessTransaction(trace.getBusinessTransaction());
                nd.setCorrelationIds(n.getCorrelationIds());
                nd.setDetails(n.getDetails());
                nd.setElapsed(n.getDuration());
                long childElapsed = 0L;
                if (n.containerNode()) {
                    for (int j = 0; j < ((ContainerNode)n).getNodes().size(); ++j) {
                        childElapsed += ((Node)((ContainerNode)n).getNodes().get(j)).getDuration();
                    }
                }
                nd.setActual(n.getDuration() - childElapsed);
                if (n.getType() == NodeType.Component) {
                    nd.setComponentType(((Component)n).getComponentType());
                } else {
                    nd.setComponentType(n.getType().name());
                }
                if (n.getFault() != null && !n.getFault().trim().isEmpty()) {
                    nd.setFault(n.getFault());
                }
                if (trace.getHostName() != null && !trace.getHostName().trim().isEmpty()) {
                    nd.setHostName(trace.getHostName());
                }
                if (trace.getPrincipal() != null && !trace.getPrincipal().trim().isEmpty()) {
                    nd.setPrincipal(trace.getPrincipal());
                }
                nd.setProperties(trace.getProperties());
                nd.setTimestamp(trace.getStartTime() + diffms);
                nd.setType(n.getType());
                nd.setUri(n.getUri());
                nd.setOperation(n.getOperation());
                rts.add(nd);
            }
            if (ignoreChildNodes || !n.interactionNode()) continue;
            this.deriveNodeDetails(trace, baseTime, ((InteractionNode)n).getNodes(), rts);
        }
    }
}

