/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.zipkin;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.zipkin.SpanDeriverUtil;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;

public class FragmentCompletionTimeDeriver
extends AbstractProcessor<Span, CompletionTime> {
    private static final Logger log = Logger.getLogger(FragmentCompletionTimeDeriver.class.getName());

    public FragmentCompletionTimeDeriver() {
        super(Processor.ProcessorType.OneToOne);
    }

    public CompletionTime processOneToOne(String tenantId, Span item) throws RetryAttemptException {
        if (item.clientSpan() && item.getParentId() == null || item.serverSpan()) {
            URL url;
            CompletionTime ct = new CompletionTime();
            ct.setId(item.getId());
            if (item.clientSpan()) {
                ct.setId(SpanUniqueIdGenerator.toUnique((Span)item));
            }
            if ((url = item.url()) != null) {
                if (item.clientSpan()) {
                    ct.setUri("client:" + url.getPath());
                } else {
                    ct.setUri(url.getPath());
                }
                ct.setEndpointType(url.getProtocol() == null ? null : url.getProtocol().toUpperCase());
            } else {
                ct.setEndpointType("Unknown");
            }
            ct.setDuration(TimeUnit.MILLISECONDS.convert(item.getDuration(), TimeUnit.MICROSECONDS));
            ct.setHostAddress(item.ipv4());
            ct.getProperties().addAll(item.binaryAnnotationMapping().getProperties());
            if (item.service() != null) {
                ct.getProperties().add(new Property("service", item.service()));
            }
            ct.setTimestamp(TimeUnit.MILLISECONDS.convert(item.getTimestamp(), TimeUnit.MICROSECONDS));
            ct.setFault(SpanDeriverUtil.deriveFault((Span)item));
            ct.setOperation(SpanDeriverUtil.deriveOperation((Span)item));
            if (log.isLoggable(Level.FINEST)) {
                log.finest("FragmentCompletionTimeDeriver ret=" + ct);
            }
            return ct;
        }
        return null;
    }
}

