/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.server.elasticsearch.ElasticsearchEmbeddedNode;

public class ElasticsearchClient {
    private static final String HAWKULAR_APM_MAPPING_JSON = "hawkular-apm-mapping.json";
    public static final String SETTINGS = "settings";
    public static final String MAPPINGS = "mappings";
    public static final String DEFAULT_SETTING = "_default_";
    private static final Logger log = Logger.getLogger(ElasticsearchClient.class.getName());
    private Client client;
    public static final String ELASTICSEARCH_HOSTS = "HAWKULAR_APM_ELASTICSEARCH_HOSTS";
    public static final String ELASTICSEARCH_HOSTS_DEFAULT = "embedded";
    private String hosts;
    public static final String ELASTICSEARCH_CLUSTER = "HAWKULAR_APM_ELASTICSEARCH_CLUSTER";
    public static final String ELASTICSEARCH_CLUSTER_DEFAULT = "elasticsearch";
    private String cluster;
    private static final Object SYNC = new Object();
    private static ElasticsearchEmbeddedNode node = null;
    private static Set<String> knownIndices = new HashSet<String>();
    private static ElasticsearchClient singleton;

    protected ElasticsearchClient() {
        if (PropertyUtil.getProperty((String)"HAWKULAR_APM_DATA_DIR") == null && System.getProperty("jboss.server.data.dir") != null) {
            System.setProperty("HAWKULAR_APM_DATA_DIR", System.getProperty("jboss.server.data.dir"));
        }
        this.hosts = PropertyUtil.getProperty((String)ELASTICSEARCH_HOSTS);
        if (this.hosts == null || this.hosts.trim().isEmpty()) {
            this.hosts = ELASTICSEARCH_HOSTS_DEFAULT;
        }
        this.cluster = PropertyUtil.getProperty((String)ELASTICSEARCH_CLUSTER, (String)ELASTICSEARCH_CLUSTER_DEFAULT);
    }

    public static synchronized ElasticsearchClient getSingleton() {
        if (singleton == null) {
            singleton = new ElasticsearchClient();
            try {
                singleton.init();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to initialise Elasticsearch client", e);
            }
        }
        return singleton;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        if (this.hosts == null) {
            throw new IllegalArgumentException("Hosts property not set ");
        }
        this.determineHostsAsProperty();
        if (this.hosts.startsWith(ELASTICSEARCH_HOSTS_DEFAULT)) {
            Object object = SYNC;
            synchronized (object) {
                if (node == null) {
                    node = new ElasticsearchEmbeddedNode();
                }
            }
            this.client = node.getClient();
        } else {
            String[] hostsArray = this.hosts.split(",");
            Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.cluster).build();
            this.client = new TransportClient(settings);
            for (String aHostsArray : hostsArray) {
                String s = aHostsArray.trim();
                String[] host = s.split(":");
                if (log.isLoggable(Level.FINE)) {
                    log.fine(" Connecting to elasticsearch host. [" + host[0] + ":" + host[1] + "]");
                }
                this.client = ((TransportClient)this.client).addTransportAddress((TransportAddress)new InetSocketTransportAddress(host[0], new Integer(host[1]).intValue()));
            }
        }
    }

    public String getIndex(String tenantId) {
        if (tenantId == null) {
            return "apm-hawkular";
        }
        return "apm-" + tenantId.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTenant(String tenantId) throws StoreException {
        String index = this.getIndex(tenantId);
        if (!knownIndices.contains(index)) {
            Set<String> set = knownIndices;
            synchronized (set) {
                if (!knownIndices.contains(index)) {
                    InputStream s;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Initialise mappings for tenantId = " + tenantId);
                    }
                    if ((s = Thread.currentThread().getContextClassLoader().getResourceAsStream(HAWKULAR_APM_MAPPING_JSON)) == null) {
                        s = ElasticsearchClient.class.getResourceAsStream("/hawkular-apm-mapping.json");
                    }
                    if (s != null) {
                        try {
                            Map dataMap;
                            String jsonDefaultUserIndex = IOUtils.toString((InputStream)s);
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Mapping [" + jsonDefaultUserIndex + "]");
                            }
                            if (this.createIndex(index, (Map)(dataMap = XContentFactory.xContent((CharSequence)jsonDefaultUserIndex).createParser(jsonDefaultUserIndex).mapAndClose()).get(SETTINGS))) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Index '" + index + "' created");
                                }
                                RefreshRequestBuilder refreshRequestBuilder = this.getClient().admin().indices().prepareRefresh(new String[]{index});
                                this.getClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                            } else if (log.isLoggable(Level.FINEST)) {
                                log.finest("Index '" + index + "' already exists. Doing nothing.");
                            }
                            this.prepareMapping(index, (Map)dataMap.get(MAPPINGS));
                            knownIndices.add(index);
                        }
                        catch (IOException ioe) {
                            throw new StoreException((Throwable)ioe);
                        }
                    } else {
                        log.warning("Could not locate 'hawkular-apm-mapping.json' index mapping file. Mapping file required to use elasticsearch");
                    }
                }
            }
        }
    }

    private boolean prepareMapping(String index, Map<String, Object> defaultMappings) {
        boolean success = true;
        for (Map.Entry<String, Object> stringObjectEntry : defaultMappings.entrySet()) {
            PutMappingResponse resp;
            Map mapping = (Map)stringObjectEntry.getValue();
            if (mapping == null) {
                throw new RuntimeException("type mapping not defined");
            }
            PutMappingRequestBuilder putMappingRequestBuilder = this.client.admin().indices().preparePutMapping(new String[0]).setIndices(new String[]{index});
            putMappingRequestBuilder.setType(stringObjectEntry.getKey());
            putMappingRequestBuilder.setSource(mapping);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Elasticsearch create mapping for index '" + index + " and type '" + stringObjectEntry.getKey() + "': " + mapping);
            }
            if ((resp = (PutMappingResponse)putMappingRequestBuilder.execute().actionGet()).isAcknowledged()) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Elasticsearch mapping for index '" + index + " and type '" + stringObjectEntry.getKey() + "' was acknowledged");
                continue;
            }
            success = false;
            log.warning("Elasticsearch mapping creation was not acknowledged for index '" + index + " and type '" + stringObjectEntry.getKey() + "'");
        }
        return success;
    }

    private boolean createIndex(String index, Map<String, Object> defaultSettings) {
        IndicesExistsResponse res = (IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{index}).execute().actionGet();
        boolean created = false;
        if (!res.isExists()) {
            CreateIndexRequestBuilder req = this.client.admin().indices().prepareCreate(index);
            req.setSettings(defaultSettings);
            created = ((CreateIndexResponse)req.execute().actionGet()).isAcknowledged();
            if (!created) {
                throw new RuntimeException("Could not create index [" + index + "]");
            }
        }
        return created;
    }

    private void determineHostsAsProperty() {
        if (this.hosts.startsWith("${") && this.hosts.endsWith("}")) {
            String hostsProperty = this.hosts.substring(2, this.hosts.length() - 1);
            this.hosts = PropertyUtil.getProperty((String)hostsProperty);
            if (this.hosts == null) {
                throw new IllegalArgumentException("Could not find property '" + hostsProperty + "'");
            }
        }
    }

    public Client getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTenant(String tenantId) {
        String index = this.getIndex(tenantId);
        Set<String> set = knownIndices;
        synchronized (set) {
            IndicesAdminClient indices = this.client.admin().indices();
            boolean indexExists = ((IndicesExistsResponse)indices.prepareExists(new String[]{index}).execute().actionGet()).isExists();
            if (indexExists) {
                indices.prepareDelete(new String[]{index}).execute().actionGet();
            }
            knownIndices.remove(index);
        }
    }

    @PreDestroy
    public void close() {
        if (node != null) {
            node.close();
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public String toString() {
        return "ElasticsearchClient[hosts='" + this.hosts + "']";
    }
}

