/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.zipkin;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.utils.EndpointUtil;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.utils.zipkin.SpanDeriverUtil;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;

public class CompletionTimeUtil {
    private CompletionTimeUtil() {
    }

    public static CompletionTime spanToCompletionTime(SpanCache spanCache, Span span) {
        URL url;
        CompletionTime completionTime = new CompletionTime();
        completionTime.setId(span.getId());
        if (span.getTimestamp() != null) {
            completionTime.setTimestamp(TimeUnit.MILLISECONDS.convert(span.getTimestamp(), TimeUnit.MICROSECONDS));
        }
        if (span.getDuration() != null) {
            completionTime.setDuration(TimeUnit.MILLISECONDS.convert(span.getDuration(), TimeUnit.MICROSECONDS));
        }
        completionTime.setOperation(SpanDeriverUtil.deriveOperation((Span)span));
        completionTime.getProperties().add(new Property("fault", SpanDeriverUtil.deriveFault((Span)span)));
        completionTime.setHostAddress(span.ipv4());
        if (span.service() != null) {
            completionTime.getProperties().add(new Property("service", span.service()));
        }
        if ((url = CompletionTimeUtil.getUrl(spanCache, span)) == null && span.serverSpan() && spanCache.get(null, SpanUniqueIdGenerator.getClientId((String)span.getId())) != null) {
            return null;
        }
        if (url != null) {
            String uri = span.clientSpan() ? EndpointUtil.encodeClientURI((String)url.getPath()) : url.getPath();
            completionTime.setUri(uri);
            completionTime.setEndpointType(url.getProtocol() == null ? null : url.getProtocol().toUpperCase());
        } else {
            completionTime.setEndpointType("Unknown");
        }
        completionTime.getProperties().addAll(span.binaryAnnotationMapping().getProperties());
        return completionTime;
    }

    static URL getUrl(SpanCache spanCache, Span span) {
        if (span.url() != null) {
            return span.url();
        }
        Span clientSpan = (Span)spanCache.get(null, SpanUniqueIdGenerator.getClientId((String)span.getId()));
        return clientSpan != null ? clientSpan.url() : null;
    }
}

