/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.zipkin;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.NodeType;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.zipkin.SpanDeriverUtil;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;

public class NodeDetailsDeriver
extends AbstractProcessor<Span, NodeDetails> {
    private static final Logger log = Logger.getLogger(NodeDetailsDeriver.class.getName());

    public NodeDetailsDeriver() {
        super(Processor.ProcessorType.OneToOne);
    }

    public NodeDetails processOneToOne(String tenantId, Span item) throws RetryAttemptException {
        NodeDetails nd = this.createTypedNodeDetails(item);
        URL url = item.url();
        if (url != null) {
            nd.setUri(url.getPath());
        }
        if (item.getTimestamp() != null) {
            nd.setTimestamp(TimeUnit.MILLISECONDS.convert(item.getTimestamp(), TimeUnit.MICROSECONDS));
        }
        if (item.getDuration() != null) {
            nd.setElapsed(TimeUnit.NANOSECONDS.convert(item.getDuration(), TimeUnit.MICROSECONDS));
            nd.setActual(TimeUnit.NANOSECONDS.convert(item.getDuration(), TimeUnit.MICROSECONDS));
        }
        nd.getProperties().addAll(item.binaryAnnotationMapping().getProperties());
        nd.setHostAddress(item.ipv4());
        if (item.service() != null) {
            nd.getProperties().add(new Property("service", item.service()));
        }
        nd.getProperties().add(new Property("fault", SpanDeriverUtil.deriveFault((Span)item)));
        nd.setOperation(SpanDeriverUtil.deriveOperation((Span)item));
        if (log.isLoggable(Level.FINEST)) {
            log.finest("NodeDetailsDeriver ret=" + nd);
        }
        return nd;
    }

    private NodeDetails createTypedNodeDetails(Span span) {
        NodeDetails nd = new NodeDetails();
        nd.setId(span.getId());
        nd.setType(NodeType.Component);
        nd.setComponentType(span.binaryAnnotationMapping().getComponentType());
        if (span.binaryAnnotationMapping().getComponentType() == null) {
            if (span.clientSpan()) {
                nd.setId(SpanUniqueIdGenerator.toUnique((Span)span));
                nd.setType(NodeType.Producer);
                nd.setComponentType("Producer");
                nd.getCorrelationIds().add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, span.getId()));
            } else if (span.serverSpan()) {
                nd.setType(NodeType.Consumer);
                nd.setComponentType("Consumer");
                nd.getCorrelationIds().add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, span.getId()));
            }
        }
        return nd;
    }
}

