/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.zipkin;

import java.util.List;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;
import org.hawkular.apm.server.processor.zipkin.CompletionTimeUtil;
import org.jboss.logging.Logger;

public class FragmentCompletionTimeDeriver
extends AbstractProcessor<Span, CompletionTime> {
    private static final Logger log = Logger.getLogger(FragmentCompletionTimeDeriver.class);
    private final SpanCache spanCache;

    public FragmentCompletionTimeDeriver(SpanCache spanCache) {
        super(Processor.ProcessorType.OneToOne);
        this.spanCache = spanCache;
    }

    public CompletionTime processOneToOne(String tenantId, Span span) throws RetryAttemptException {
        if (span.getParentId() == null || span.serverSpan()) {
            CompletionTime ct = CompletionTimeUtil.spanToCompletionTime(this.spanCache, span);
            if (ct == null) {
                return null;
            }
            if (span.serverSpan() && ct.getUri() == null) {
                if (this.spanCache.get(null, SpanUniqueIdGenerator.getClientId((String)span.getId())) != null) {
                    log.warnf("NO URL, span = %s", (Object)span);
                    return null;
                }
                log.debugf("Server span does not contain URL, waiting for client span, span id=%s", (Object)span.getId());
                throw new RetryAttemptException("URL is null, span id = " + span.getId());
            }
            if (span.clientSpan()) {
                ct.setId(SpanUniqueIdGenerator.toUnique((Span)span));
            }
            log.debugf("FragmentCompletionTimeDeriver ret= %s", (Object)ct);
            return ct;
        }
        return null;
    }

    public long getRetryDelay(List<Span> spans, int retryCount) {
        return 5000L;
    }
}

