/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.zipkin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.server.api.model.zipkin.Annotation;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;
import org.hawkular.apm.server.processor.zipkin.CompletionTimeProcessing;
import org.hawkular.apm.server.processor.zipkin.CompletionTimeUtil;
import org.jboss.logging.Logger;

public class CompletionTimeProcessingDeriver
extends AbstractProcessor<CompletionTimeProcessing, CompletionTimeProcessing> {
    private static final Logger log = Logger.getLogger(CompletionTimeProcessingDeriver.class);
    private final SpanCache spanCache;

    public CompletionTimeProcessingDeriver(SpanCache spanCache) {
        super(Processor.ProcessorType.OneToOne);
        this.spanCache = spanCache;
    }

    public CompletionTimeProcessing processOneToOne(String tenantId, CompletionTimeProcessing completionTimeProcessing) throws RetryAttemptException {
        if (completionTimeProcessing.getCompletionTime() != null) {
            return null;
        }
        Span rootSpan = completionTimeProcessing.getRootSpan();
        Set trace = this.spanCache.getTrace(tenantId, rootSpan.getTraceId());
        if (trace == null) {
            throw new RetryAttemptException("trace not present in the cache");
        }
        Annotation lastAnnotation = this.extractLastAnnotation(trace);
        if (lastAnnotation == null) {
            throw new RetryAttemptException("No annotation present, cannot calculate completion time - trying retry");
        }
        if (completionTimeProcessing.getLastTimestamp() == null || completionTimeProcessing.getLastTimestamp() < lastAnnotation.getTimestamp()) {
            completionTimeProcessing.setLastTimestamp(lastAnnotation.getTimestamp());
            return completionTimeProcessing;
        }
        CompletionTime completionTime = CompletionTimeUtil.spanToCompletionTime(this.spanCache, rootSpan);
        if (completionTime == null) {
            log.warnf("NO URL, span = %s", (Object)rootSpan);
            return null;
        }
        if (completionTime.getUri() == null && rootSpan.serverSpan() && this.spanCache.get(null, SpanUniqueIdGenerator.getClientId((String)rootSpan.getId())) == null) {
            throw new RetryAttemptException("URL is null, span id = " + rootSpan.getId());
        }
        completionTime.setProperties(this.extractProperties(trace));
        completionTime.setDuration(this.getTraceDuration(rootSpan, lastAnnotation.getTimestamp()).longValue());
        completionTimeProcessing.setCompletionTime(completionTime);
        return completionTimeProcessing;
    }

    public long getRetryDelay(List<CompletionTimeProcessing> completionTimeProcessings, int retryCount) {
        return 5000L;
    }

    public long getDeliveryDelay(List<CompletionTimeProcessing> completionTimeProcessings) {
        return 5000L;
    }

    private Long getTraceDuration(Span rootSpan, long lastAnnotationTimestamp) {
        long estimatedDuration = lastAnnotationTimestamp - rootSpan.getTimestamp();
        if (estimatedDuration < rootSpan.getDuration()) {
            estimatedDuration = rootSpan.getDuration();
        }
        return estimatedDuration;
    }

    private Annotation extractLastAnnotation(Set<Span> spans) {
        Annotation lastAnnotation = null;
        for (Span span : spans) {
            for (Annotation annotation : span.getAnnotations()) {
                if (lastAnnotation != null && lastAnnotation.getTimestamp() >= annotation.getTimestamp()) continue;
                lastAnnotation = annotation;
            }
        }
        return lastAnnotation;
    }

    private Set<Property> extractProperties(Set<Span> spans) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Span span : spans) {
            properties.addAll(span.binaryAnnotationMapping().getProperties());
        }
        return properties;
    }
}

