/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.zipkin;

import java.net.URL;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.NodeType;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.zipkin.SpanDeriverUtil;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;
import org.jboss.logging.Logger;

public class NodeDetailsDeriver
extends AbstractProcessor<Span, NodeDetails> {
    private static final Logger log = Logger.getLogger((String)NodeDetailsDeriver.class.getName());
    private final SpanCache spanCache;

    public NodeDetailsDeriver(SpanCache spanCache) {
        super(Processor.ProcessorType.OneToOne);
        this.spanCache = spanCache;
    }

    public NodeDetails processOneToOne(String tenantId, Span item) throws RetryAttemptException {
        NodeDetails nd = this.createTypedNodeDetails(item);
        URL url = item.url();
        if (url != null) {
            nd.setUri(url.getPath());
        } else if (item.serverSpan()) {
            Span clientSpan = (Span)this.spanCache.get(null, SpanUniqueIdGenerator.getClientId((String)item.getId()));
            if (clientSpan == null) {
                log.debugf("Server span does not contain URL, waiting for client span, span id=%s", (Object)item.getId());
                throw new RetryAttemptException("URL is null, span id = " + item.getId());
            }
            url = clientSpan.url();
            if (url == null) {
                log.debugf("Unable to determine URL for server span id=%s", (Object)item.getId());
                return null;
            }
            nd.setUri(url.getPath());
        }
        if (item.getTimestamp() != null) {
            nd.setTimestamp(item.getTimestamp().longValue());
        }
        if (item.getDuration() != null) {
            nd.setElapsed(item.getDuration().longValue());
            nd.setActual(item.getDuration().longValue());
        }
        nd.getProperties().addAll(item.binaryAnnotationMapping().getProperties());
        nd.setHostAddress(item.ipv4());
        if (item.service() != null) {
            nd.getProperties().add(new Property("service", (Object)item.service()));
        }
        nd.getProperties().add(new Property("fault", (Object)SpanDeriverUtil.deriveFault((Span)item)));
        nd.setOperation(SpanDeriverUtil.deriveOperation((Span)item));
        nd.setInitial(item.topLevelSpan() || item.serverSpan());
        log.debugf("NodeDetailsDeriver ret=%s", (Object)nd);
        return nd;
    }

    private NodeDetails createTypedNodeDetails(Span span) {
        NodeDetails nd = new NodeDetails();
        nd.setId(span.getId());
        nd.setTraceId(span.getTraceId());
        nd.setType(NodeType.Component);
        nd.setComponentType(span.binaryAnnotationMapping().getComponentType());
        if (span.binaryAnnotationMapping().getComponentType() == null) {
            if (span.clientSpan()) {
                nd.setId(SpanUniqueIdGenerator.toUnique((Span)span));
                nd.setType(NodeType.Producer);
                nd.setComponentType("Producer");
                nd.getCorrelationIds().add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, span.getId()));
            } else if (span.serverSpan()) {
                nd.setType(NodeType.Consumer);
                nd.setComponentType("Consumer");
                nd.getCorrelationIds().add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, span.getId()));
            }
        }
        return nd;
    }
}

