/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.zipkin;

import java.net.URL;
import java.util.UUID;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.api.model.events.SourceInfo;
import org.hawkular.apm.api.utils.EndpointUtil;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.SourceInfoUtil;
import org.hawkular.apm.server.api.utils.zipkin.SpanDeriverUtil;
import org.hawkular.apm.server.processor.zipkin.CompletionTimeUtil;
import org.jboss.logging.Logger;

public class CommunicationDetailsDeriver
extends AbstractProcessor<Span, CommunicationDetails> {
    private static final Logger log = Logger.getLogger(CommunicationDetailsDeriver.class);
    private final SpanCache spanCache;

    public CommunicationDetailsDeriver(SpanCache spanCache) {
        super(Processor.ProcessorType.OneToOne);
        this.spanCache = spanCache;
    }

    public boolean isReportRetryExpirationAsWarning() {
        return false;
    }

    public CommunicationDetails processOneToOne(String tenantId, Span item) throws RetryAttemptException {
        CommunicationDetails ret = null;
        log.debugf("Derive communication details for span: %s", (Object)item);
        if (item.serverSpan()) {
            SourceInfo si = SourceInfoUtil.getSourceInfo((String)tenantId, (Span)item, (SpanCache)this.spanCache);
            if (si != null) {
                ret = new CommunicationDetails();
                ret.setId(UUID.randomUUID().toString());
                ret.setLinkId(item.getId());
                ret.setSource(si.getEndpoint().toString());
                URL url = CompletionTimeUtil.getUrl(this.spanCache, item);
                String operation = SpanDeriverUtil.deriveOperation((Span)item);
                if (url != null) {
                    ret.setTarget(EndpointUtil.encodeEndpoint((String)url.getPath(), (String)operation));
                } else {
                    log.debugf("NO URL, span = %s", (Object)item);
                }
                long diff = si.getDuration() - item.getDuration();
                if (diff > 0L) {
                    ret.setLatency(diff / 2L);
                } else if (diff < 0L) {
                    log.debugf("WARNING: Negative latency for consumer = %s", (Object)item);
                }
                ret.setSourceDuration(si.getDuration());
                ret.setTargetDuration(item.getDuration().longValue());
                ret.setMultiConsumer(si.isMultipleConsumers());
                ret.getProperties().addAll(item.binaryAnnotationMapping().getProperties());
                ret.getProperties().addAll(si.getProperties());
                if (item.service() != null) {
                    ret.getProperties().add(new Property("service", (Object)item.service()));
                }
                ret.setTraceId(item.getTraceId());
                ret.setSourceFragmentId(si.getFragmentId());
                ret.setSourceHostName(si.getHostName());
                ret.setSourceHostAddress(si.getHostAddress());
                ret.setTargetFragmentId(item.getId());
                ret.setTargetHostAddress(item.ipv4());
                ret.setTimestamp(si.getTimestamp());
                long timestampOffset = item.getTimestamp() - si.getTimestamp() - ret.getLatency();
                ret.setTimestampOffset(timestampOffset);
            } else {
                log.debugf("WARNING: Producer information not available [id checked = %s]", (Object)item.getId());
                throw new RetryAttemptException("Producer information not available [id checked = " + item.getId() + "]");
            }
        }
        log.debugf("Derived communication details: %s", ret);
        return ret;
    }
}

