/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.communicationdetails;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.api.model.events.SourceInfo;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.utils.EndpointUtil;
import org.hawkular.apm.server.api.services.CacheException;
import org.hawkular.apm.server.api.services.SourceInfoCache;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.SourceInfoUtil;

public class CommunicationDetailsDeriver
extends AbstractProcessor<Trace, CommunicationDetails> {
    private static final Logger log = Logger.getLogger(CommunicationDetailsDeriver.class.getName());
    @Inject
    private SourceInfoCache sourceInfoCache;

    public CommunicationDetailsDeriver() {
        super(Processor.ProcessorType.OneToOne);
    }

    public SourceInfoCache getSourceInfoCache() {
        return this.sourceInfoCache;
    }

    public void setSourceInfoCache(SourceInfoCache sourceInfoCache) {
        this.sourceInfoCache = sourceInfoCache;
    }

    public void initialise(String tenantId, List<Trace> items) throws RetryAttemptException {
        List sourceInfoList = SourceInfoUtil.getSourceInfo((String)tenantId, items);
        try {
            this.sourceInfoCache.store(tenantId, sourceInfoList);
        }
        catch (CacheException e) {
            throw new RetryAttemptException((Throwable)e);
        }
    }

    public CommunicationDetails processOneToOne(String tenantId, Trace item) throws RetryAttemptException {
        Consumer consumer;
        List cids;
        CommunicationDetails ret = null;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Derive communication details for trace fragment: " + item);
        }
        if (item.getNodes().size() == 1 && ((Node)item.getNodes().get(0)).getClass() == Consumer.class && !(cids = (consumer = (Consumer)item.getNodes().get(0)).getCorrelationIds()).isEmpty()) {
            String lastId = null;
            for (int i = 0; ret == null && i < cids.size(); ++i) {
                String id = ((CorrelationIdentifier)cids.get(i)).getValue();
                SourceInfo si = (SourceInfo)this.sourceInfoCache.get(tenantId, id);
                if (si != null) {
                    ret = new CommunicationDetails();
                    ret.setId(UUID.randomUUID().toString());
                    ret.setLinkId(id);
                    ret.setBusinessTransaction(item.getBusinessTransaction());
                    ret.setSource(si.getEndpoint().toString());
                    ret.setTarget(EndpointUtil.encodeEndpoint((String)consumer.getUri(), (String)consumer.getOperation()));
                    ret.setLatency(CommunicationDetailsDeriver.calculateLatency(si, item, consumer));
                    ret.setSourceDuration(si.getDuration());
                    ret.setTargetDuration(consumer.getDuration());
                    ret.setMultiConsumer(si.isMultipleConsumers());
                    ret.setInternal(consumer.getEndpointType() == null);
                    ret.getProperties().addAll(consumer.getProperties());
                    ret.getProperties().addAll(si.getProperties());
                    ret.setSourceFragmentId(si.getFragmentId());
                    ret.setSourceHostName(si.getHostName());
                    ret.setSourceHostAddress(si.getHostAddress());
                    ret.setTargetFragmentId(item.getId());
                    ret.setTargetHostName(item.getHostName());
                    ret.setTargetHostAddress(item.getHostAddress());
                    ret.setTargetFragmentDuration(item.calculateDuration());
                    ret.setPrincipal(item.getPrincipal());
                    ret.setTimestamp(si.getTimestamp());
                    long timestampOffset = item.getStartTime() - si.getTimestamp() - ret.getLatency();
                    ret.setTimestampOffset(timestampOffset);
                    StringBuilder nodeId = new StringBuilder(item.getId());
                    nodeId.append(":0");
                    CommunicationDetailsDeriver.initialiseOutbound((Node)consumer, ((Node)item.getNodes().get(0)).getBaseTime(), ret, nodeId);
                    continue;
                }
                lastId = id;
            }
            if (ret == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("WARNING: Producer information not available [last id checked = " + lastId + "]");
                }
                throw new RetryAttemptException("Producer information not available [last id checked = " + lastId + "]");
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Derived communication details: " + ret);
        }
        return ret;
    }

    protected static long calculateLatency(SourceInfo si, Trace trace, Consumer consumer) {
        long latency = 0L;
        if (!si.isMultipleConsumers()) {
            long diff = TimeUnit.MILLISECONDS.convert(si.getDuration() - consumer.getDuration(), TimeUnit.NANOSECONDS);
            if (diff > 0L) {
                latency = diff >> 1;
            } else if (diff < 0L) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("WARNING: Negative latency based on source/target duration, consumer trace = " + trace);
                }
                latency = CommunicationDetailsDeriver.calculateTimestampLatency(si, trace);
            }
        } else {
            latency = CommunicationDetailsDeriver.calculateTimestampLatency(si, trace);
        }
        return latency;
    }

    private static long calculateTimestampLatency(SourceInfo si, Trace trace) {
        long latency = 0L;
        latency = trace.getStartTime() - si.getTimestamp();
        if (latency < 0L) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("WARNING: Negative latency based on timestamps, consumer trace = " + trace);
            }
            latency = 0L;
        }
        return latency;
    }

    protected static void initialiseOutbound(Node n, long baseTime, CommunicationDetails cd, StringBuilder nodeId) {
        CommunicationDetails.Outbound ob = new CommunicationDetails.Outbound();
        ob.getLinkIds().add(nodeId.toString());
        ob.setMultiConsumer(true);
        ob.setProducerOffset(TimeUnit.MILLISECONDS.convert(n.getBaseTime() - baseTime, TimeUnit.NANOSECONDS));
        cd.getOutbound().add(ob);
        if (n.getClass() == Producer.class) {
            ob = new CommunicationDetails.Outbound();
            for (int j = 0; j < n.getCorrelationIds().size(); ++j) {
                CorrelationIdentifier ci = (CorrelationIdentifier)n.getCorrelationIds().get(j);
                if (ci.getScope() != CorrelationIdentifier.Scope.Interaction && ci.getScope() != CorrelationIdentifier.Scope.ControlFlow) continue;
                ob.getLinkIds().add(ci.getValue());
            }
            if (!ob.getLinkIds().isEmpty()) {
                ob.setMultiConsumer(((Producer)n).multipleConsumers());
                ob.setProducerOffset(TimeUnit.MILLISECONDS.convert(n.getBaseTime() - baseTime, TimeUnit.NANOSECONDS));
                cd.getOutbound().add(ob);
            }
        } else if (n.containerNode()) {
            for (int i = 0; i < ((ContainerNode)n).getNodes().size(); ++i) {
                int len = nodeId.length();
                nodeId.append(':');
                nodeId.append(i);
                CommunicationDetailsDeriver.initialiseOutbound((Node)((ContainerNode)n).getNodes().get(i), baseTime, cd, nodeId);
                nodeId.delete(len, nodeId.length());
            }
        }
    }
}

