/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.tracecompletiontime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.model.events.EndpointRef;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.utils.EndpointUtil;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.processor.tracecompletiontime.TraceCompletionInformation;
import org.hawkular.apm.server.processor.tracecompletiontime.TraceCompletionInformationUtil;

public class TraceCompletionInformationInitiator
extends AbstractProcessor<Trace, TraceCompletionInformation> {
    private static final Logger log = Logger.getLogger(TraceCompletionInformationInitiator.class.getName());

    public TraceCompletionInformationInitiator() {
        super(Processor.ProcessorType.OneToOne);
    }

    public TraceCompletionInformation processOneToOne(String tenantId, Trace item) throws RetryAttemptException {
        Node n;
        if (!item.getNodes().isEmpty() && ((n = (Node)item.getNodes().get(0)).getClass() != Consumer.class || n.getCorrelationIds().isEmpty())) {
            TraceCompletionInformation ci = new TraceCompletionInformation();
            CompletionTime ct = new CompletionTime();
            ct.setId(item.getId());
            EndpointRef ep = EndpointUtil.getSourceEndpoint((Trace)item);
            ct.setUri(ep.getUri());
            ct.setOperation(ep.getOperation());
            if (n.getClass() == Consumer.class) {
                ct.setEndpointType(((Consumer)n).getEndpointType());
            }
            ct.setBusinessTransaction(item.getBusinessTransaction());
            ct.setDuration(item.calculateDuration());
            ct.setPrincipal(item.getPrincipal());
            ct.setProperties(item.allProperties());
            ct.setTimestamp(item.getStartTime());
            ci.setCompletionTime(ct);
            StringBuilder nodeId = new StringBuilder(item.getId());
            nodeId.append(":0");
            TraceCompletionInformationUtil.initialiseLinks(ci, n.getBaseTime(), n, nodeId);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Creating initial completion time information = " + ci);
            }
            return ci;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("No completion information initiated for trace fragment = " + item);
        }
        return null;
    }
}

