/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.fragmentcompletiontime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;

public class FragmentCompletionTimeDeriver
extends AbstractProcessor<Trace, CompletionTime> {
    private static final Logger log = Logger.getLogger(FragmentCompletionTimeDeriver.class.getName());

    public FragmentCompletionTimeDeriver() {
        super(Processor.ProcessorType.OneToOne);
    }

    public CompletionTime processOneToOne(String tenantId, Trace item) throws RetryAttemptException {
        if (!item.getNodes().isEmpty()) {
            Node n = (Node)item.getNodes().get(0);
            CompletionTime ct = new CompletionTime();
            ct.setId(item.getFragmentId());
            ct.setUri(n.getUri());
            ct.setOperation(n.getOperation());
            if (n.getClass() == Consumer.class) {
                ct.setEndpointType(((Consumer)n).getEndpointType());
                ct.setInternal(((Consumer)n).getEndpointType() == null || ((Consumer)n).getEndpointType().trim().isEmpty());
            }
            ct.setTransaction(item.getTransaction());
            ct.setDuration(item.calculateDuration());
            ct.setHostName(item.getHostName());
            ct.setProperties(item.allProperties());
            ct.setTimestamp(item.getTimestamp());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("FragmentCompletionTimeDeriver ret=" + ct);
            }
            return ct;
        }
        return null;
    }
}

