/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.tracecompletiontime;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.server.processor.tracecompletiontime.TraceCompletionInformation;

public class TraceCompletionInformationUtil {
    private static final Logger log = Logger.getLogger(TraceCompletionInformationUtil.class.getName());

    public static void initialiseLinks(TraceCompletionInformation ci, long fragmentBaseTime, Node n, StringBuilder nodeId) {
        TraceCompletionInformation.Communication c = new TraceCompletionInformation.Communication();
        c.getIds().add(nodeId.toString());
        c.setMultipleConsumers(true);
        c.setBaseDuration(n.getTimestamp() - fragmentBaseTime);
        c.setExpire(System.currentTimeMillis() + 4000L);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Adding communication to completion information: ci=" + ci + " comms=" + c);
        }
        ci.getCommunications().add(c);
        if (n.getClass() == Producer.class) {
            List cids = n.findCorrelationIds(new CorrelationIdentifier.Scope[]{CorrelationIdentifier.Scope.Interaction, CorrelationIdentifier.Scope.ControlFlow});
            if (!cids.isEmpty()) {
                c = new TraceCompletionInformation.Communication();
                for (int i = 0; i < cids.size(); ++i) {
                    c.getIds().add(((CorrelationIdentifier)cids.get(i)).getValue());
                }
                c.setMultipleConsumers(((Producer)n).multipleConsumers());
                c.setBaseDuration(n.getTimestamp() - fragmentBaseTime);
                c.setExpire(System.currentTimeMillis() + 4000L);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Adding communication to completion information: ci=" + ci + " comms=" + c);
                }
                ci.getCommunications().add(c);
            }
        } else if (n.containerNode()) {
            ContainerNode cn = (ContainerNode)n;
            for (int i = 0; i < cn.getNodes().size(); ++i) {
                int len = nodeId.length();
                nodeId.append(':');
                nodeId.append(i);
                TraceCompletionInformationUtil.initialiseLinks(ci, fragmentBaseTime, (Node)cn.getNodes().get(i), nodeId);
                nodeId.delete(len, nodeId.length());
            }
        }
    }
}

