/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.modules.BootModuleLoader;

public class Main {
    private final String[] args;

    public Main(String ... args) throws Throwable {
        this.args = args;
    }

    public static void main(String ... args) throws Throwable {
        try {
            System.setProperty("swarm.isuberjar", Boolean.TRUE.toString());
            new Main(args).run();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    public void run() throws Throwable {
        this.setupBootModuleLoader();
        this.invoke(this.getMainClass());
    }

    public void setupBootModuleLoader() {
        System.setProperty("boot.module.loader", BootModuleLoader.class.getName());
    }

    public Class<?> getMainClass() throws IOException, URISyntaxException, ModuleLoadException, ClassNotFoundException {
        String mainClassName = ApplicationEnvironment.get().getMainClassName();
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create("swarm.application"));
        return module.getClassLoader().loadClass(mainClassName);
    }

    public String getMainClassName() {
        return ApplicationEnvironment.get().getMainClassName();
    }

    public void invoke(Class<?> mainClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method mainMethod = mainClass.getMethod("main", String[].class);
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            throw new NoSuchMethodException("Main method is not static for " + mainClass);
        }
        mainMethod.invoke(null, new Object[]{this.args});
    }
}

