/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.app.vertx.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.tests.app.vertx.opentracing.VertxMessageExtractAdapter;

public class InventoryManager {
    private Map<String, JsonObject> items = new HashMap<String, JsonObject>();
    private MessageConsumer<JsonObject> getItemConsumer;
    private MessageConsumer<JsonObject> ordersConfirmedConsumer;

    private InventoryManager(EventBus eb, Tracer tracer) {
        this.initItems();
        this.initGetItemConsumer(eb, tracer);
        this.initOrdersConfirmedConsumer(eb, tracer);
    }

    public static InventoryManager create(EventBus eb, Tracer tracer) {
        return new InventoryManager(eb, tracer);
    }

    protected void initItems() {
        this.items.put("laptop", new JsonObject().put("itemId", "laptop").put("quantity", Integer.valueOf(5)));
        this.items.put("car", new JsonObject().put("itemId", "car").put("quantity", Integer.valueOf(8)));
        this.items.put("book", new JsonObject().put("itemId", "book").put("quantity", Integer.valueOf(9)));
        this.items.put("chair", new JsonObject().put("itemId", "chair").put("quantity", Integer.valueOf(7)));
        this.items.put("dvd", new JsonObject().put("itemId", "dvd").put("quantity", Integer.valueOf(6)));
    }

    protected void initGetItemConsumer(EventBus eb, Tracer tracer) {
        this.getItemConsumer = eb.consumer("InventoryManager.getItem");
        this.getItemConsumer.handler(message -> {
            block27: {
                JsonObject req = (JsonObject)message.body();
                SpanContext spanCtx = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(req));
                try (Span getItemSpan = tracer.buildSpan("GetItem").asChildOf(spanCtx).withTag("service", "InventoryManager").start();){
                    if (!req.containsKey("itemId")) {
                        message.fail(1, "Item id missing");
                        break block27;
                    }
                    try (Span queryInventorySpan = tracer.buildSpan("QueryInventory").asChildOf(getItemSpan).withTag("database.url", "InventoryDB").withTag("database.statement", "SELECT item FROM Inventory WHERE id = ?").start();){
                        JsonObject acct = this.items.get(req.getString("itemId"));
                        if (acct == null) {
                            this.sendError(2, "Item not found", (Message<JsonObject>)message, getItemSpan);
                        } else {
                            message.reply((Object)acct);
                        }
                    }
                }
            }
        });
    }

    protected void initOrdersConfirmedConsumer(EventBus eb, Tracer tracer) {
        this.ordersConfirmedConsumer = eb.consumer("Orders.confirmed");
        this.ordersConfirmedConsumer.handler(message -> {
            JsonObject order = (JsonObject)message.body();
            SpanContext spanCtx = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(order));
            try (Span orderConfirmedSpan = tracer.buildSpan("UpdateQuantity").asChildOf(spanCtx).withTag("service", "InventoryManager").start();){
                Span queryInventorySpan = tracer.buildSpan("WriteInventory").asChildOf(orderConfirmedSpan).withTag("database.url", "InventoryDB").withTag("database.statement", "UPDATE Inventory SET item=?").start();
                Throwable throwable = null;
                if (queryInventorySpan != null) {
                    if (throwable != null) {
                        try {
                            queryInventorySpan.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        queryInventorySpan.close();
                    }
                }
            }
        });
    }

    private void sendError(int statusCode, String text, Message<JsonObject> message, Span span) {
        message.fail(statusCode, text);
        if (span != null) {
            span.setTag("fault", text == null ? Integer.toString(statusCode) : text);
        }
    }
}

