/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.common;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;

public class Wait {
    public static void until(Callable<Boolean> condition) {
        Wait.until(condition, 10L, TimeUnit.SECONDS);
    }

    public static void until(Callable<Boolean> condition, long timeout, TimeUnit timeUnit) {
        Wait.until(condition, timeout, timeUnit, 50L);
    }

    public static void until(Callable<Boolean> condition, long timeout, TimeUnit timeUnit, long frequency) {
        FutureTask<Void> futureTask = new FutureTask<Void>(() -> {
            while (!((Boolean)condition.call()).booleanValue()) {
                Thread.sleep(frequency);
            }
            return null;
        });
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.submit(futureTask);
        try {
            futureTask.get(timeout, timeUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            futureTask.cancel(true);
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static void forPortToBeUsed(int port) {
        Wait.until(Wait.portChecker(false, port));
    }

    public static void forPortToBeFree(int port) {
        Wait.until(Wait.portChecker(true, port));
    }

    private static Callable<Boolean> portChecker(boolean freeCheck, int port) {
        return () -> {
            Socket socket = new Socket();
            socket.setSoTimeout(500);
            try {
                System.out.println("Trying to connect to port " + port);
                socket.connect(new InetSocketAddress(port), 500);
                socket.close();
                System.out.println("Was able to connect to port " + port);
                return !freeCheck;
            }
            catch (ConnectException | SocketTimeoutException ignored) {
                System.out.println("Was NOT able to connect to port " + port);
                return freeCheck;
            }
        };
    }
}

