/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.common;

import java.util.List;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.tests.server.TestTraceServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ClientTestBase {
    private TestTraceServer testAPMServer = new TestTraceServer();

    public int getPort() {
        return 8080;
    }

    @Before
    public void init() {
        try {
            this.testAPMServer.setPort(this.getPort());
            this.testAPMServer.setShutdownTimer(-1);
            this.testAPMServer.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setProcessHeaders(false);
        this.setProcessContent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void close() {
        try {
            this.testAPMServer.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ClientTestBase e = this;
            synchronized (e) {
                this.wait(2000L);
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Failed to wait after test close");
        }
    }

    public TestTraceServer getTestTraceServer() {
        return this.testAPMServer;
    }

    public void setTestAPMServer(TestTraceServer testAPMServer) {
        this.testAPMServer = testAPMServer;
    }

    protected void checkInteractionCorrelationIdentifiers(Producer producer, Consumer consumer) {
        CorrelationIdentifier pcid = (CorrelationIdentifier)producer.getCorrelationIds().iterator().next();
        CorrelationIdentifier ccid = (CorrelationIdentifier)consumer.getCorrelationIds().iterator().next();
        Assert.assertEquals((Object)pcid, (Object)ccid);
    }

    protected <T extends Node> void findNodes(List<Node> nodes, Class<T> cls, List<T> results) {
        for (Node n : nodes) {
            if (n instanceof ContainerNode) {
                this.findNodes(((ContainerNode)n).getNodes(), cls, results);
            }
            if (!cls.isAssignableFrom(n.getClass())) continue;
            results.add(n);
        }
    }

    protected void setProcessHeaders(boolean b) {
        System.setProperty("hawkular-apm.test.process.headers", "" + b);
    }

    protected void setProcessContent(boolean b) {
        System.setProperty("hawkular-apm.test.process.content", "" + b);
    }

    protected boolean isProcessHeaders() {
        return Boolean.getBoolean("hawkular-apm.test.process.headers");
    }

    protected boolean isProcessContent() {
        return Boolean.getBoolean("hawkular-apm.test.process.content");
    }
}

