/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.config.CollectorConfiguration;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.ConfigurationLoader;

public class TestTraceServer {
    private static final String HAWKULAR_APM_TEST_SERVER_HOST = "hawkular-apm.test.server.host";
    private static final String HAWKULAR_APM_TEST_SERVER_PORT = "hawkular-apm.test.server.port";
    private static final String HAWKULAR_APM_TEST_SERVER_SHUTDOWN = "hawkular-apm.test.server.shutdown";
    private static final int DEFAULT_SHUTDOWN_TIMER = 30000;
    private static final Logger log = Logger.getLogger(TestTraceServer.class.getName());
    private Undertow server = null;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<Trace>> TRACE_LIST = new TypeReference<List<Trace>>(){};
    private List<Trace> traces = new ArrayList<Trace>();
    private int port = 8080;
    private String host = "localhost";
    private int shutdown = 30000;
    private CollectorConfiguration testConfig;

    public TestTraceServer() {
        if (System.getProperties().containsKey(HAWKULAR_APM_TEST_SERVER_HOST)) {
            this.host = System.getProperty(HAWKULAR_APM_TEST_SERVER_HOST);
        }
        if (System.getProperties().containsKey(HAWKULAR_APM_TEST_SERVER_PORT)) {
            this.port = Integer.parseInt(System.getProperty(HAWKULAR_APM_TEST_SERVER_PORT));
        }
        if (System.getProperties().containsKey(HAWKULAR_APM_TEST_SERVER_SHUTDOWN)) {
            this.shutdown = Integer.parseInt(System.getProperty(HAWKULAR_APM_TEST_SERVER_SHUTDOWN));
        }
    }

    public static void main(String[] args) {
        TestTraceServer main = new TestTraceServer();
        main.run();
    }

    public List<Trace> getTraces() {
        return this.traces;
    }

    public void setTraces(List<Trace> traces) {
        this.traces = traces;
    }

    public void setShutdownTimer(int timer) {
        this.shutdown = timer;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTestConfig(CollectorConfiguration testConfig) {
        this.testConfig = testConfig;
    }

    public void run() {
        log.info("************** STARTED TEST TRACE SERVICE: host=" + this.host + " port=" + this.port + " shutdownTimer=" + this.shutdown);
        if (this.shutdown != -1) {
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(TestTraceServer.this.shutdown);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    log.severe("************** ABORTING TEST TRACE SERVICE");
                    System.exit(1);
                }
            });
            t.setDaemon(true);
            t.start();
        }
        this.server = Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)Handlers.path().addPrefixPath("hawkular/apm/shutdown", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                log.info("Shutdown called");
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                exchange.getResponseSender().send("ok");
                TestTraceServer.this.shutdown();
            }
        }).addPrefixPath("hawkular/apm/fragments", new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.isInIoThread()) {
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                log.info("Transactions request received: " + exchange);
                if (exchange.getRequestMethod() == Methods.POST) {
                    exchange.startBlocking();
                    InputStream is = exchange.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    StringBuilder builder = new StringBuilder();
                    String str = null;
                    while ((str = reader.readLine()) != null) {
                        builder.append(str);
                    }
                    is.close();
                    List btxns = (List)mapper.readValue(builder.toString(), TRACE_LIST);
                    List list = TestTraceServer.this.traces;
                    synchronized (list) {
                        TestTraceServer.this.traces.addAll(btxns);
                    }
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                    exchange.getResponseSender().send("");
                } else if (exchange.getRequestMethod() == Methods.GET) {
                    List list = TestTraceServer.this.traces;
                    synchronized (list) {
                        String btxns = mapper.writeValueAsString((Object)TestTraceServer.this.traces);
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                        exchange.getResponseSender().send(btxns);
                    }
                }
            }
        }).addPrefixPath("hawkular/apm/config/collector", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.isInIoThread()) {
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                log.info("Config request received: " + exchange);
                if (exchange.getRequestMethod() == Methods.GET) {
                    CollectorConfiguration config = ConfigurationLoader.getConfiguration(null);
                    if (TestTraceServer.this.testConfig != null) {
                        config.merge(TestTraceServer.this.testConfig, true);
                    }
                    String cc = mapper.writeValueAsString((Object)config);
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                    exchange.getResponseSender().send(cc);
                }
            }
        })).build();
        this.server.start();
    }

    public void shutdown() {
        log.info("************ TEST TRACE SERVICE EXITING");
        this.server.stop();
    }
}

