/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.tracecompletiontime;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.processor.tracecompletiontime.TraceCompletionInformation;

public class TraceCompletionInformationUtil {
    private static final Logger log = Logger.getLogger(TraceCompletionInformationUtil.class.getName());

    public static void initialiseCommunications(TraceCompletionInformation ci, long fragmentBaseTime, long baseDuration, Node n) {
        if (n.getClass() == Producer.class) {
            List cids = n.getCorrelationIds(CorrelationIdentifier.Scope.Interaction);
            if (!cids.isEmpty()) {
                TraceCompletionInformation.Communication c = new TraceCompletionInformation.Communication();
                for (int i = 0; i < cids.size(); ++i) {
                    c.getIds().add(((CorrelationIdentifier)cids.get(i)).getValue());
                }
                c.setMultipleConsumers(((Producer)n).multipleConsumers());
                c.setBaseDuration(baseDuration + TimeUnit.MILLISECONDS.convert(n.getBaseTime() - fragmentBaseTime, TimeUnit.NANOSECONDS));
                c.setExpire(System.currentTimeMillis() + 60000L);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Adding communication to completion information: ci=" + ci + " comms=" + c);
                }
                ci.getCommunications().add(c);
            }
        } else if (n.containerNode()) {
            ContainerNode cn = (ContainerNode)n;
            for (int i = 0; i < cn.getNodes().size(); ++i) {
                TraceCompletionInformationUtil.initialiseCommunications(ci, fragmentBaseTime, baseDuration, (Node)cn.getNodes().get(i));
            }
        }
    }
}

