/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.utils;

import org.hawkular.btm.api.model.btxn.Node;

public class NodeUtil {
    private static final String BTM_ORIGINAL_URI = "btm_original_uri";

    public static boolean isURIRewritten(Node node) {
        return node.getDetails().containsKey(BTM_ORIGINAL_URI);
    }

    public static void rewriteURI(Node node, String uri) {
        node.getDetails().put(BTM_ORIGINAL_URI, node.getUri());
        node.setUri(uri);
    }

    public static boolean isOriginalURI(Node node, String uri) {
        if (node.getUri().equals(uri)) {
            return true;
        }
        String original = node.getDetails().get(BTM_ORIGINAL_URI);
        if (original != null) {
            return original.equals(uri);
        }
        return false;
    }
}

