/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.model.btxn;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Issue;
import org.hawkular.btm.api.model.btxn.NodeType;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ContainerNode.class)})
@ApiModel(subTypes={ContainerNode.class}, discriminator="type")
public abstract class Node {
    @JsonInclude
    private NodeType type;
    @JsonInclude
    private String uri;
    @JsonInclude
    private long baseTime = 0L;
    @JsonInclude
    private long duration = 0L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String fault;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String faultDescription;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> details = new HashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<CorrelationIdentifier> correlationIds = new ArrayList<CorrelationIdentifier>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Issue> issues = new ArrayList<Issue>();

    public Node(NodeType type) {
        this.type = type;
    }

    public Node(NodeType type, String uri) {
        this(type);
        this.uri = uri;
    }

    public boolean containerNode() {
        return false;
    }

    public boolean interactionNode() {
        return false;
    }

    public NodeType getType() {
        return this.type;
    }

    public Node setType(NodeType type) {
        this.type = type;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public Node setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public long getBaseTime() {
        return this.baseTime;
    }

    public Node setBaseTime(long baseTime) {
        this.baseTime = baseTime;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public Node setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public String getFault() {
        return this.fault;
    }

    public Node setFault(String fault) {
        this.fault = fault;
        return this;
    }

    public String getFaultDescription() {
        return this.faultDescription;
    }

    public Node setFaultDescription(String faultDescription) {
        this.faultDescription = faultDescription;
        return this;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public Node setDetails(Map<String, String> details) {
        this.details = details;
        return this;
    }

    public List<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public Node setCorrelationIds(List<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
        return this;
    }

    public void addInteractionId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
    }

    public void addGlobalId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Global, id));
    }

    public void addLocalId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Local, id));
    }

    public List<CorrelationIdentifier> getCorrelationIds(CorrelationIdentifier.Scope scope) {
        ArrayList<CorrelationIdentifier> ret = null;
        for (int i = 0; i < this.correlationIds.size(); ++i) {
            CorrelationIdentifier cid = this.correlationIds.get(i);
            if (cid.getScope() != scope) continue;
            if (ret == null) {
                ret = new ArrayList<CorrelationIdentifier>();
            }
            ret.add(cid);
        }
        return ret == null ? Collections.emptyList() : ret;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Issue> issues) {
        this.issues = issues;
    }

    protected long endTime() {
        long ret = 0L;
        if (this.baseTime > 0L) {
            ret = this.baseTime + this.duration;
        }
        return ret;
    }

    protected long completedTime() {
        return this.overallEndTime();
    }

    protected long completedDuration() {
        long ret = 0L;
        if (this.baseTime > 0L) {
            ret = this.overallEndTime() - this.baseTime;
        }
        return ret;
    }

    protected long overallEndTime() {
        return this.endTime();
    }

    protected void findCorrelatedNodes(CorrelationIdentifier cid, Set<Node> nodes) {
        if (this.isCorrelated(cid)) {
            nodes.add(this);
        }
    }

    protected boolean isCorrelated(CorrelationIdentifier cid) {
        for (CorrelationIdentifier id : this.correlationIds) {
            if (!id.equals(cid)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationIds == null ? 0 : this.correlationIds.hashCode());
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.fault == null ? 0 : this.fault.hashCode());
        result = 31 * result + (int)(this.baseTime ^ this.baseTime >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.correlationIds == null ? other.correlationIds != null : !this.correlationIds.equals(other.correlationIds)) {
            return false;
        }
        if (this.details == null ? other.details != null : !this.details.equals(other.details)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.fault == null ? other.fault != null : !this.fault.equals(other.fault)) {
            return false;
        }
        if (this.baseTime != other.baseTime) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

