/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.shaded.org.mvel2.integration.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.btm.shaded.org.mvel2.UnresolveablePropertyException;
import org.hawkular.btm.shaded.org.mvel2.integration.VariableResolver;
import org.hawkular.btm.shaded.org.mvel2.integration.VariableResolverFactory;
import org.hawkular.btm.shaded.org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.hawkular.btm.shaded.org.mvel2.integration.impl.MapVariableResolver;
import org.hawkular.btm.shaded.org.mvel2.integration.impl.PrecachedMapVariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedMapVariableResolverFactory
extends BaseVariableResolverFactory {
    protected Map<String, Object> variables;

    public CachedMapVariableResolverFactory() {
    }

    public CachedMapVariableResolverFactory(Map<String, Object> variables) {
        this.variables = variables;
        this.variableResolvers = new HashMap(variables.size() * 2);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            this.variableResolvers.put(entry.getKey(), new PrecachedMapVariableResolver(entry, entry.getKey()));
        }
    }

    public CachedMapVariableResolverFactory(Map<String, Object> variables, VariableResolverFactory nextFactory) {
        this.variables = variables;
        this.variableResolvers = new HashMap(variables.size() * 2);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            this.variableResolvers.put(entry.getKey(), new PrecachedMapVariableResolver(entry, entry.getKey()));
        }
        this.nextFactory = nextFactory;
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        try {
            VariableResolver vr = this.getVariableResolver(name);
            vr.setValue(value);
            return vr;
        }
        catch (UnresolveablePropertyException e) {
            MapVariableResolver vr = new MapVariableResolver(this.variables, name);
            this.addResolver(name, vr).setValue(value);
            return vr;
        }
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        VariableResolver vr;
        try {
            vr = this.getVariableResolver(name);
        }
        catch (UnresolveablePropertyException e) {
            vr = null;
        }
        if (vr != null && vr.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name);
        }
        vr = new MapVariableResolver(this.variables, name, type);
        this.addResolver(name, vr).setValue(value);
        return vr;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        VariableResolver vr = (VariableResolver)this.variableResolvers.get(name);
        if (vr != null) {
            return vr;
        }
        if (this.variables.containsKey(name)) {
            vr = new MapVariableResolver(this.variables, name);
            this.variableResolvers.put(name, vr);
            return vr;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(name);
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
    }

    @Override
    public boolean isResolveable(String name) {
        return this.variableResolvers != null && this.variableResolvers.containsKey(name) || this.variables != null && this.variables.containsKey(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    protected VariableResolver addResolver(String name, VariableResolver vr) {
        if (this.variableResolvers == null) {
            this.variableResolvers = new HashMap();
        }
        this.variableResolvers.put(name, vr);
        return vr;
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers != null && this.variableResolvers.containsKey(name);
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            if (this.variables != null) {
                return new HashSet<String>(this.variables.keySet());
            }
            return new HashSet<String>(0);
        }
        if (this.variables != null) {
            return new HashSet<String>(this.variables.keySet());
        }
        return new HashSet<String>(0);
    }
}

