/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.shaded.org.mvel2.integration.impl;

import java.util.HashMap;
import java.util.Map;
import org.hawkular.btm.shaded.org.mvel2.UnresolveablePropertyException;
import org.hawkular.btm.shaded.org.mvel2.integration.VariableResolver;
import org.hawkular.btm.shaded.org.mvel2.integration.VariableResolverFactory;
import org.hawkular.btm.shaded.org.mvel2.integration.impl.LocalVariableResolverFactory;
import org.hawkular.btm.shaded.org.mvel2.integration.impl.MapVariableResolver;
import org.hawkular.btm.shaded.org.mvel2.integration.impl.MapVariableResolverFactory;
import org.hawkular.btm.shaded.org.mvel2.integration.impl.SimpleValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocalVariableResolverFactory
extends MapVariableResolverFactory
implements LocalVariableResolverFactory {
    private boolean noTilt = false;

    public DefaultLocalVariableResolverFactory() {
        super(new HashMap());
    }

    public DefaultLocalVariableResolverFactory(Map<String, Object> variables) {
        super(variables);
    }

    public DefaultLocalVariableResolverFactory(Map<String, Object> variables, VariableResolverFactory nextFactory) {
        super(variables, nextFactory);
    }

    public DefaultLocalVariableResolverFactory(Map<String, Object> variables, boolean cachingSafe) {
        super(variables);
    }

    public DefaultLocalVariableResolverFactory(VariableResolverFactory nextFactory) {
        super(new HashMap<String, Object>(), nextFactory);
    }

    public DefaultLocalVariableResolverFactory(VariableResolverFactory nextFactory, String[] indexedVariables) {
        super(new HashMap<String, Object>(), nextFactory);
        this.indexedVariableNames = indexedVariables;
        this.indexedVariableResolvers = new VariableResolver[indexedVariables.length];
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index) {
        if (this.indexedVariableNames == null) {
            return null;
        }
        if (this.indexedVariableResolvers[index] == null) {
            this.indexedVariableResolvers[index] = super.getVariableResolver(this.indexedVariableNames[index]);
            return this.indexedVariableResolvers[index];
        }
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.indexedVariableNames == null) {
            return super.getVariableResolver(name);
        }
        int idx = this.variableIndexOf(name);
        if (idx != -1) {
            if (this.indexedVariableResolvers[idx] == null) {
                this.indexedVariableResolvers[idx] = new SimpleValueResolver(null);
            }
            this.variableResolvers.put(this.indexedVariableNames[idx], null);
            return this.indexedVariableResolvers[idx];
        }
        return super.getVariableResolver(name);
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        VariableResolver vr;
        if (this.indexedVariableNames == null) {
            return super.createVariable(name, value, type);
        }
        boolean newVar = false;
        try {
            int idx = this.variableIndexOf(name);
            if (idx != -1) {
                vr = new SimpleValueResolver(value);
                if (this.indexedVariableResolvers[idx] == null) {
                    this.indexedVariableResolvers[idx] = vr;
                }
            } else {
                return super.createVariable(name, value, type);
            }
            this.variableResolvers.put(this.indexedVariableNames[idx], vr);
            vr = this.indexedVariableResolvers[idx];
            newVar = true;
        }
        catch (UnresolveablePropertyException e) {
            vr = null;
        }
        if (!newVar && vr != null && vr.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name);
        }
        vr = new MapVariableResolver(this.variables, name, type);
        this.addResolver(name, vr).setValue(value);
        return vr;
    }

    public VariableResolverFactory setNoTilt(boolean noTilt) {
        this.noTilt = noTilt;
        return this;
    }

    @Override
    public void setTiltFlag(boolean tiltFlag) {
        if (!this.noTilt) {
            super.setTiltFlag(tiltFlag);
        }
    }
}

