/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.shaded.org.mvel2.util;

import org.hawkular.btm.shaded.org.mvel2.CompileException;
import org.hawkular.btm.shaded.org.mvel2.ParserContext;
import org.hawkular.btm.shaded.org.mvel2.ast.EndOfStatement;
import org.hawkular.btm.shaded.org.mvel2.ast.Function;
import org.hawkular.btm.shaded.org.mvel2.util.ExecutionStack;
import org.hawkular.btm.shaded.org.mvel2.util.ParseTools;

public class FunctionParser {
    private String name;
    private int cursor;
    private int length;
    private int fields;
    private char[] expr;
    private ParserContext pCtx;
    private ExecutionStack splitAccumulator;

    public FunctionParser(String functionName, int cursor, int endOffset, char[] expr, int fields, ParserContext pCtx, ExecutionStack splitAccumulator) {
        this.name = functionName;
        this.cursor = cursor;
        this.length = endOffset;
        this.expr = expr;
        this.fields = fields;
        this.pCtx = pCtx;
        this.splitAccumulator = splitAccumulator;
    }

    public Function parse() {
        int blockEnd;
        int blockStart;
        int start = this.cursor;
        int startCond = 0;
        int endCond = 0;
        int end = this.cursor + this.length;
        this.cursor = ParseTools.captureToNextTokenJunction(this.expr, this.cursor, end, this.pCtx);
        this.cursor = ParseTools.nextNonBlank(this.expr, this.cursor);
        if (this.expr[this.cursor] == '(') {
            startCond = this.cursor;
            this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, startCond, end, '(', this.pCtx);
            endCond = this.cursor++;
            ++startCond;
            this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
            if (this.cursor >= end) {
                throw new CompileException("incomplete statement", this.expr, this.cursor);
            }
            if (this.expr[this.cursor] == '{') {
                blockStart = this.cursor;
                blockEnd = this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, blockStart, end, '{', this.pCtx);
            } else {
                blockStart = this.cursor - 1;
                blockEnd = this.cursor = ParseTools.captureToEOS(this.expr, this.cursor, end, this.pCtx);
            }
        } else if (this.expr[this.cursor] == '{') {
            blockStart = this.cursor;
            blockEnd = this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, blockStart, end, '{', this.pCtx);
        } else {
            blockStart = this.cursor - 1;
            blockEnd = this.cursor = ParseTools.captureToEOS(this.expr, this.cursor, end, this.pCtx);
        }
        blockStart = ParseTools.trimRight(this.expr, blockStart + 1);
        blockEnd = ParseTools.trimLeft(this.expr, start, blockEnd);
        ++this.cursor;
        if (this.splitAccumulator != null && ParseTools.isStatementNotManuallyTerminated(this.expr, this.cursor)) {
            this.splitAccumulator.add(new EndOfStatement(this.pCtx));
        }
        return new Function(this.name, this.expr, startCond, endCond - startCond, blockStart, blockEnd - blockStart, this.fields, this.pCtx);
    }

    public String getName() {
        return this.name;
    }

    public int getCursor() {
        return this.cursor;
    }
}

