/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.util.Map;
import org.hawkular.btm.api.internal.actions.ExpressionHandler;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.DataExpression;
import org.hawkular.btm.api.model.config.btxn.DataSource;
import org.hawkular.btm.api.model.config.btxn.Expression;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;

public abstract class DataExpressionHandler
extends ExpressionHandler {
    private DataSource source;
    private String key;
    private int index = 0;

    public DataExpressionHandler(Expression expression) {
        super(expression);
    }

    @Override
    public boolean isUsesHeaders() {
        return ((DataExpression)this.getExpression()).getSource() == DataSource.Header;
    }

    @Override
    public boolean isUsesContent() {
        return ((DataExpression)this.getExpression()).getSource() == DataSource.Content;
    }

    @Override
    public void init(Processor processor, ProcessorAction action, boolean predicate) {
        DataExpression expr = (DataExpression)this.getExpression();
        this.source = expr.getSource();
        this.key = expr.getKey();
        if (this.source == DataSource.Content) {
            this.index = Integer.parseInt(this.key);
        }
    }

    protected Object getDataValue(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.source == DataSource.Content) {
            return values[this.index];
        }
        if (this.source == DataSource.Header) {
            return headers.get(this.key);
        }
        return null;
    }
}

