/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.hawkular.btm.api.model.analytics.PropertyInfo;
import org.hawkular.btm.api.model.analytics.URIInfo;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.api.services.Criteria;

public abstract class AbstractAnalyticsService
implements AnalyticsService {
    private static final Logger log = Logger.getLogger(AbstractAnalyticsService.class.getName());
    @Inject
    private ConfigurationService configService;

    public ConfigurationService getConfigurationService() {
        return this.configService;
    }

    public void setConfigurationService(ConfigurationService cs) {
        this.configService = cs;
    }

    protected abstract List<BusinessTransaction> getFragments(String var1, Criteria var2);

    @Override
    public List<URIInfo> getUnboundURIs(String tenantId, long startTime, long endTime, boolean compress) {
        Criteria criteria = new Criteria();
        criteria.setStartTime(startTime).setEndTime(endTime);
        List<BusinessTransaction> fragments = this.getFragments(tenantId, criteria);
        return this.doGetUnboundURIs(tenantId, fragments, compress);
    }

    @Override
    public List<String> getBoundURIs(String tenantId, String businessTransaction, long startTime, long endTime) {
        ArrayList<String> ret = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.setBusinessTransaction(businessTransaction).setStartTime(startTime).setEndTime(endTime);
        List<BusinessTransaction> fragments = this.getFragments(tenantId, criteria);
        for (int i = 0; i < fragments.size(); ++i) {
            BusinessTransaction btxn = fragments.get(i);
            this.obtainURIs(btxn.getNodes(), ret);
        }
        return ret;
    }

    @Override
    public List<PropertyInfo> getPropertyInfo(String tenantId, String businessTransaction, long startTime, long endTime) {
        ArrayList<PropertyInfo> ret = new ArrayList<PropertyInfo>();
        ArrayList<String> propertyNames = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.setStartTime(startTime).setEndTime(endTime).setBusinessTransaction(businessTransaction);
        List<BusinessTransaction> fragments = this.getFragments(tenantId, criteria);
        for (int i = 0; i < fragments.size(); ++i) {
            BusinessTransaction btxn = fragments.get(i);
            for (String property : btxn.getProperties().keySet()) {
                if (propertyNames.contains(property)) continue;
                propertyNames.add(property);
                PropertyInfo pi = new PropertyInfo();
                pi.setName(property);
                ret.add(pi);
            }
        }
        Collections.sort(ret, new Comparator<PropertyInfo>(){

            @Override
            public int compare(PropertyInfo arg0, PropertyInfo arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return ret;
    }

    protected static List<URIInfo> compressURIInfo(List<URIInfo> uris) {
        ArrayList<URIInfo> others = new ArrayList<URIInfo>();
        URIPart rootPart = new URIPart();
        for (int i = 0; i < uris.size(); ++i) {
            URIInfo uri = uris.get(i);
            if (uri.getUri() != null && uri.getUri().length() > 1 && uri.getUri().charAt(0) == '/') {
                String[] parts = uri.getUri().split("/");
                AbstractAnalyticsService.buildTree(rootPart, parts, 1, uri.getEndpointType());
                continue;
            }
            others.add(new URIInfo(uri));
        }
        List<URIInfo> info = null;
        if (uris.size() != others.size()) {
            rootPart.collapse();
            info = AbstractAnalyticsService.extractURIInfo(rootPart);
            info.addAll(others);
        } else {
            info = others;
        }
        AbstractAnalyticsService.initURIInfo(info);
        return info;
    }

    protected static void buildTree(URIPart parent, String[] parts, int index, String endpointType) {
        URIPart child = parent.addChild(parts[index]);
        if (index < parts.length - 1) {
            AbstractAnalyticsService.buildTree(child, parts, index + 1, endpointType);
        } else {
            child.setEndpointType(endpointType);
        }
    }

    protected static List<URIInfo> extractURIInfo(URIPart root) {
        ArrayList<URIInfo> uris = new ArrayList<URIInfo>();
        root.extractURIInfo(uris, "");
        return uris;
    }

    protected static void initURIInfo(List<URIInfo> uris) {
        for (int i = 0; i < uris.size(); ++i) {
            URIInfo info = uris.get(i);
            info.setRegex(AbstractAnalyticsService.createRegex(info.getUri(), info.metaURI()));
            if (!info.metaURI()) continue;
            StringBuilder template = new StringBuilder();
            String[] parts = info.getUri().split("/");
            String part = null;
            int paramNo = 1;
            for (int j = 1; j < parts.length; ++j) {
                template.append("/");
                if (parts[j].equals("*")) {
                    if (part == null) {
                        template.append("{");
                        template.append("param");
                        template.append(paramNo++);
                        template.append("}");
                    } else {
                        if (part.length() > 1 && part.charAt(part.length() - 1) == 's') {
                            part = part.substring(0, part.length() - 1);
                        }
                        template.append("{");
                        template.append(part);
                        template.append("Id}");
                    }
                    part = null;
                    continue;
                }
                part = parts[j];
                template.append(part);
            }
            info.setTemplate(template.toString());
        }
    }

    protected List<URIInfo> doGetUnboundURIs(String tenantId, List<BusinessTransaction> fragments, boolean compress) {
        List<URIInfo> ret = new ArrayList<URIInfo>();
        HashMap<String, URIInfo> map = new HashMap<String, URIInfo>();
        for (int i = 0; i < fragments.size(); ++i) {
            BusinessTransaction btxn = fragments.get(i);
            if (!btxn.initialFragment() || btxn.getNodes().isEmpty() || btxn.getName() != null) continue;
            if (btxn.getNodes().get(0) instanceof Consumer) {
                Consumer consumer = (Consumer)btxn.getNodes().get(0);
                String uri = consumer.getUri();
                if (map.containsKey(uri) || consumer.getFault() != null) continue;
                URIInfo info = new URIInfo();
                info.setUri(uri);
                info.setEndpointType(consumer.getEndpointType());
                ret.add(info);
                map.put(uri, info);
                continue;
            }
            this.obtainProducerURIs(btxn.getNodes(), ret, map);
        }
        if (this.configService != null) {
            Map<String, BusinessTxnConfig> configs = this.configService.getBusinessTransactions(tenantId, 0L);
            for (BusinessTxnConfig config : configs.values()) {
                if (config.getFilter() == null || config.getFilter().getInclusions() == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Remove unbound URIs associated with btxn config=" + config);
                }
                for (String filter : config.getFilter().getInclusions()) {
                    if (filter == null || filter.trim().length() <= 0) continue;
                    Iterator<URIInfo> iter = ret.iterator();
                    while (iter.hasNext()) {
                        URIInfo info = iter.next();
                        if (!Pattern.matches(filter, info.getUri())) continue;
                        iter.remove();
                    }
                }
            }
        }
        if (compress) {
            ret = AbstractAnalyticsService.compressURIInfo(ret);
        }
        Collections.sort(ret, new Comparator<URIInfo>(){

            @Override
            public int compare(URIInfo arg0, URIInfo arg1) {
                return arg0.getUri().compareTo(arg1.getUri());
            }
        });
        return ret;
    }

    protected void obtainURIs(List<Node> nodes, List<String> uris) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (node.getUri() != null && !uris.contains(node.getUri())) {
                uris.add(node.getUri());
            }
            if (!(node instanceof ContainerNode)) continue;
            this.obtainURIs(((ContainerNode)node).getNodes(), uris);
        }
    }

    protected void obtainProducerURIs(List<Node> nodes, List<URIInfo> uris, Map<String, URIInfo> map) {
        for (int i = 0; i < nodes.size(); ++i) {
            String uri;
            Node node = nodes.get(i);
            if (node instanceof Producer && !map.containsKey(uri = node.getUri())) {
                URIInfo info = new URIInfo();
                info.setUri(uri);
                info.setEndpointType(((Producer)node).getEndpointType());
                uris.add(info);
                map.put(uri, info);
            }
            if (!(node instanceof ContainerNode)) continue;
            this.obtainProducerURIs(((ContainerNode)node).getNodes(), uris, map);
        }
    }

    protected static String createRegex(String uri, boolean meta) {
        StringBuffer regex = new StringBuffer();
        regex.append('^');
        for (int i = 0; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            if ("*".indexOf(ch) != -1) {
                regex.append('.');
            } else if ("\\.^$|?+[]{}()".indexOf(ch) != -1) {
                regex.append('\\');
            }
            regex.append(ch);
        }
        regex.append('$');
        return regex.toString();
    }

    public static class URIPart {
        private static final int CHILD_THRESHOLD = 10;
        private int count = 1;
        private Map<String, URIPart> children;
        private String endpointType;

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public Map<String, URIPart> getChildren() {
            return this.children;
        }

        public void setChildren(Map<String, URIPart> children) {
            this.children = children;
        }

        public URIPart addChild(String name) {
            URIPart child = null;
            if (this.children == null) {
                this.children = new HashMap<String, URIPart>();
            }
            if (!this.children.containsKey(name)) {
                child = new URIPart();
                this.children.put(name, child);
            } else {
                child = this.children.get(name);
                child.setCount(child.getCount() + 1);
            }
            return child;
        }

        public void collapse() {
            if (this.children != null && !this.children.isEmpty()) {
                if (this.children.size() >= 10) {
                    URIPart merged = new URIPart();
                    for (URIPart cur : this.children.values()) {
                        merged.merge(cur);
                    }
                    this.children.clear();
                    this.children.put("*", merged);
                    merged.collapse();
                } else {
                    for (URIPart part : this.children.values()) {
                        part.collapse();
                    }
                }
            }
        }

        public void merge(URIPart toMerge) {
            if (this.endpointType == null) {
                this.endpointType = toMerge.getEndpointType();
            }
            this.count += toMerge.getCount();
            if (toMerge.getChildren() != null) {
                if (this.children == null) {
                    this.children = new HashMap<String, URIPart>();
                }
                for (String child : toMerge.getChildren().keySet()) {
                    if (this.getChildren().containsKey(child)) {
                        this.getChildren().get(child).merge(toMerge.getChildren().get(child));
                        continue;
                    }
                    this.getChildren().put(child, toMerge.getChildren().get(child));
                }
            }
        }

        public void extractURIInfo(List<URIInfo> uris, String uri) {
            if (this.endpointType != null) {
                URIInfo info = new URIInfo();
                info.setUri(uri);
                info.setEndpointType(this.endpointType);
                uris.add(info);
            }
            if (this.getChildren() != null) {
                for (String child : this.getChildren().keySet()) {
                    URIPart part = this.getChildren().get(child);
                    part.extractURIInfo(uris, uri + "/" + child);
                }
            }
        }

        public String getEndpointType() {
            return this.endpointType;
        }

        public void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }
    }
}

