/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.manager;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.services.ServiceResolver;
import org.hawkular.btm.client.api.BusinessTransactionCollector;
import org.hawkular.btm.client.api.HeadersAccessor;
import org.hawkular.btm.client.api.SessionManager;
import org.hawkular.btm.client.manager.ArrayBuilder;
import org.hawkular.btm.client.manager.ClientManager;
import org.hawkular.btm.client.manager.faults.FaultDescriptor;
import org.hawkular.btm.client.manager.io.InstrumentedInputStream;
import org.hawkular.btm.client.manager.io.InstrumentedOutputStream;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;

public class RuleHelper
extends Helper
implements SessionManager {
    public static final String BINARY_SQL_MARKER = "<binary>";
    private static final Logger log = Logger.getLogger(RuleHelper.class.getName());
    private static Map<String, HeadersAccessor> headersAccessors = new HashMap<String, HeadersAccessor>();
    private static List<FaultDescriptor> faultDescriptors;

    protected RuleHelper(Rule rule) {
        super(rule);
    }

    public String getRuleName() {
        return this.rule.getName();
    }

    public BusinessTransactionCollector collector() {
        return ClientManager.collector();
    }

    public String createUUID() {
        return UUID.randomUUID().toString();
    }

    public String getID(String type, Object obj) {
        return type + obj.hashCode();
    }

    public boolean isInstanceOf(Object obj, Class<?> clz) {
        if (obj == null || clz == null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("isInstanceOf error: obj=" + obj + " clz=" + clz);
            }
            return false;
        }
        return clz.isAssignableFrom(obj.getClass());
    }

    public <T> T cast(Object obj, Class<T> clz) {
        if (!clz.isAssignableFrom(obj.getClass())) {
            return null;
        }
        return clz.cast(obj);
    }

    public String simpleClassName(Object obj) {
        return obj.getClass().getSimpleName();
    }

    public String toString(Object obj) {
        return obj.toString();
    }

    public int hashCode(Object obj) {
        return obj.hashCode();
    }

    public String formatSQL(Object obj) {
        String sql = null;
        if (obj != null && (sql = this.toString(obj)) != null) {
            if (sql.startsWith("prep")) {
                sql = sql.replaceFirst("prep[0-9]*: ", "");
            }
            sql = sql.replaceAll("X'.*'", BINARY_SQL_MARKER);
        }
        return sql;
    }

    protected FaultDescriptor getFaultDescriptor(Object fault) {
        for (int i = 0; i < faultDescriptors.size(); ++i) {
            if (!faultDescriptors.get(i).isValid(fault)) continue;
            return faultDescriptors.get(i);
        }
        return null;
    }

    public String faultName(Object fault) {
        FaultDescriptor fd = this.getFaultDescriptor(fault);
        if (fd != null) {
            return fd.getName(fault);
        }
        return fault.getClass().getSimpleName();
    }

    public String faultDescription(Object fault) {
        FaultDescriptor fd = this.getFaultDescriptor(fault);
        if (fd != null) {
            return fd.getDescription(fault);
        }
        return fault.toString();
    }

    public String removeSuffix(String original, String suffix) {
        if (original.endsWith(suffix)) {
            return original.substring(0, original.length() - suffix.length());
        }
        return original;
    }

    public String removeAfter(String original, String marker) {
        int index = original.indexOf(marker);
        if (index != -1) {
            return original.substring(0, index);
        }
        return original;
    }

    public ArrayBuilder createArrayBuilder() {
        return new ArrayBuilder();
    }

    public Map<String, String> getHeaders(String type, Object target) {
        HeadersAccessor accessor = this.getHeadersAccessor(type);
        if (accessor != null) {
            Map<String, String> ret = accessor.getHeaders(target);
            return ret;
        }
        return null;
    }

    protected HeadersAccessor getHeadersAccessor(String type) {
        return headersAccessors.get(type);
    }

    @Override
    public boolean activate(String uri, String id) {
        return this.collector().session().activate(uri, id);
    }

    @Override
    public boolean activate(String uri) {
        return this.collector().session().activate(uri);
    }

    @Override
    public boolean isActive() {
        return this.collector().session().isActive();
    }

    @Override
    public void retainNode(String id) {
        this.collector().session().retainNode(id);
    }

    @Override
    public void releaseNode(String id) {
        this.collector().session().releaseNode(id);
    }

    @Override
    public Node retrieveNode(String id) {
        return this.collector().session().retrieveNode(id);
    }

    @Override
    public void initiateCorrelation(String id) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Initiate correlation location=[" + this.getRuleName() + "] id=[" + id + "]");
        }
        this.collector().session().initiateCorrelation(id);
    }

    @Override
    public boolean isCorrelated(String id) {
        return this.collector().session().isCorrelated(id);
    }

    @Override
    public void correlate(String id) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Correlate location=[" + this.getRuleName() + "] id=[" + id + "]");
        }
        this.collector().session().correlate(id);
    }

    @Override
    public void completeCorrelation(String id) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Complete correlation location=[" + this.getRuleName() + "] id=[" + id + "]");
        }
        this.collector().session().completeCorrelation(id);
    }

    @Override
    public void unlink() {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Unlink location=[" + this.getRuleName() + "]");
        }
        this.collector().session().unlink();
    }

    @Override
    public void suppress() {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Suppress location=[" + this.getRuleName() + "]");
        }
        this.collector().session().suppress();
    }

    @Override
    public void assertComplete() {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Assert complete location=[" + this.getRuleName() + "]");
        }
        this.collector().session().assertComplete();
    }

    public String getBusinessTransactionName() {
        return this.collector().getName();
    }

    public String getLevel() {
        return this.collector().getLevel();
    }

    public void initInBuffer(Object obj) {
        this.collector().initInBuffer(this.getRuleName(), obj);
    }

    public boolean isInBufferActive(Object obj) {
        return this.collector().isInBufferActive(this.getRuleName(), obj);
    }

    public void appendInBuffer(Object obj, byte[] data, int offset, int len, boolean close) {
        if (len > 0) {
            this.collector().appendInBuffer(this.getRuleName(), obj, data, offset, len);
        }
        if (close) {
            this.collector().recordInBuffer(this.getRuleName(), obj);
        }
    }

    public void recordInBuffer(Object obj) {
        this.collector().recordInBuffer(this.getRuleName(), obj);
    }

    public void initOutBuffer(Object obj) {
        this.collector().initOutBuffer(this.getRuleName(), obj);
    }

    public boolean isOutBufferActive(Object obj) {
        return this.collector().isOutBufferActive(this.getRuleName(), obj);
    }

    public void appendOutBuffer(Object obj, byte[] data, int offset, int len, boolean close) {
        if (len > 0) {
            this.collector().appendOutBuffer(this.getRuleName(), obj, data, offset, len);
        }
        if (close) {
            this.collector().recordOutBuffer(this.getRuleName(), obj);
        }
    }

    public void recordOutBuffer(Object obj) {
        this.collector().recordOutBuffer(this.getRuleName(), obj);
    }

    public boolean isInProcessed() {
        return this.collector().isInProcessed(this.getRuleName());
    }

    public boolean isInContentProcessed() {
        return this.collector().isInContentProcessed(this.getRuleName());
    }

    public boolean isOutProcessed() {
        return this.collector().isOutProcessed(this.getRuleName());
    }

    public boolean isOutContentProcessed() {
        return this.collector().isOutContentProcessed(this.getRuleName());
    }

    public OutputStream createInOutputStream(OutputStream os) {
        return new InstrumentedOutputStream(this.collector(), Direction.In, os, null);
    }

    public OutputStream createInOutputStream(OutputStream os, String linkId) {
        return new InstrumentedOutputStream(this.collector(), Direction.In, os, linkId);
    }

    public OutputStream createOutOutputStream(OutputStream os) {
        return new InstrumentedOutputStream(this.collector(), Direction.Out, os, null);
    }

    public OutputStream createOutOutputStream(OutputStream os, String linkId) {
        return new InstrumentedOutputStream(this.collector(), Direction.Out, os, linkId);
    }

    public InputStream createInInputStream(InputStream is) {
        return new InstrumentedInputStream(this.collector(), Direction.In, is);
    }

    public InputStream createOutInputStream(InputStream is) {
        return new InstrumentedInputStream(this.collector(), Direction.Out, is);
    }

    static {
        List<HeadersAccessor> accessors = ServiceResolver.getServices(HeadersAccessor.class);
        for (HeadersAccessor accessor : accessors) {
            headersAccessors.put(accessor.getTargetType(), accessor);
        }
        faultDescriptors = ServiceResolver.getServices(FaultDescriptor.class);
    }
}

