/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.btxn.publisher.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionPublisher;

public class BusinessTransactionPublisherRESTClient
implements BusinessTransactionPublisher {
    private static final Logger log = Logger.getLogger((String)BusinessTransactionPublisherRESTClient.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String HAWKULAR_PERSONA = "Hawkular-Persona";
    private String username = System.getProperty("hawkular-btm.username");
    private String password = System.getProperty("hawkular-btm.password");
    private String authorization = null;
    private String uri = System.getProperty("hawkular-btm.uri");

    public BusinessTransactionPublisherRESTClient() {
        if (this.uri != null && this.uri.length() > 0 && this.uri.charAt(this.uri.length() - 1) != '/') {
            this.uri = this.uri + '/';
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public int getInitialRetryCount() {
        return 0;
    }

    public void publish(String tenantId, List<BusinessTransaction> btxns) throws Exception {
        URL url = new URL(this.uri + "fragments");
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Publish btxns [tenant=" + tenantId + "][url=" + url + "]: " + btxns);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        this.addHeaders(connection, tenantId);
        OutputStream os = connection.getOutputStream();
        os.write(mapper.writeValueAsBytes(btxns));
        os.flush();
        os.close();
        int statusCode = connection.getResponseCode();
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Status code is: " + statusCode);
        }
        if (statusCode != 200) {
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Failed to publish business transaction fragments: status=[" + statusCode + "]");
            }
            throw new Exception(connection.getResponseMessage());
        }
    }

    public void publish(String tenantId, List<BusinessTransaction> items, int retryCount, long delay) throws Exception {
        throw new UnsupportedOperationException("Cannot set the retry count and delay");
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_PERSONA, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }

    public boolean isEnabled() {
        return this.uri != null && this.uri.startsWith("http");
    }
}

