/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.btxn.service.casses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.AbstractBusinessTransactionService;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.jboss.logging.Logger;

@Singleton
public class BusinessTransactionServiceCassEs
extends AbstractBusinessTransactionService {
    private final Logger log = Logger.getLogger(BusinessTransactionServiceCassEs.class);
    private static Map<String, BusinessTransaction> idMap = new HashMap<String, BusinessTransaction>();
    private static List<BusinessTransaction> txns = new ArrayList<BusinessTransaction>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStore(String tenantId, BusinessTransaction btxn) throws Exception {
        List<BusinessTransaction> list = txns;
        synchronized (list) {
            BusinessTransaction old = idMap.put(btxn.getId(), btxn);
            if (old != null) {
                txns.remove(old);
            }
            txns.add(btxn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BusinessTransaction doGet(String tenantId, String id) {
        BusinessTransaction ret = null;
        List<BusinessTransaction> list = txns;
        synchronized (list) {
            ret = idMap.get(id);
        }
        this.log.tracef("Get business transaction with id[%s] is: %s", (Object)id, (Object)ret);
        return ret;
    }

    protected List<BusinessTransaction> doQuery(String tenantId, BusinessTransactionCriteria criteria) {
        ArrayList<BusinessTransaction> ret = new ArrayList<BusinessTransaction>();
        txns.stream().filter(p -> criteria.isValid(p)).forEach(p -> ret.add((BusinessTransaction)p));
        this.log.tracef("Query business transactions with criteria[%s] is: %s", (Object)criteria, ret);
        return ret;
    }
}

