/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.manager.config;

import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.instrumentation.InstrumentAction;
import org.hawkular.btm.api.model.config.instrumentation.ProcessContent;
import org.hawkular.btm.client.manager.config.InstrumentActionTransformer;

public class ProcessContentTransformer
implements InstrumentActionTransformer {
    @Override
    public Class<? extends InstrumentAction> getActionType() {
        return ProcessContent.class;
    }

    @Override
    public String convertToRuleAction(InstrumentAction action) {
        ProcessContent pcAction = (ProcessContent)action;
        StringBuilder builder = new StringBuilder();
        builder.append("collector().");
        if (pcAction.getDirection() == Direction.In) {
            builder.append("processIn(");
        } else {
            builder.append("processOut(");
        }
        builder.append("getRuleName(),null,createArrayBuilder()");
        for (String expr : pcAction.getValueExpressions()) {
            builder.append(".add(");
            builder.append(expr);
            builder.append(')');
        }
        builder.append(".get()");
        builder.append(")");
        return builder.toString();
    }
}

