/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.hawkular.btm.api.client.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.Node;

public class FragmentBuilder {
    private static final Logger log = Logger.getLogger(FragmentBuilder.class.getName());
    private BusinessTransaction businessTransaction = new BusinessTransaction().setId(UUID.randomUUID().toString());
    private Stack<Node> nodeStack = new Stack();
    private Map<String, Node> retainedNodes = new HashMap<String, Node>();
    private List<String> unlinkedIds = new ArrayList<String>();

    public boolean isComplete() {
        return this.nodeStack.isEmpty() && this.retainedNodes.isEmpty();
    }

    public BusinessTransaction getBusinessTransaction() {
        return this.businessTransaction;
    }

    public Node getCurrentNode() {
        return this.nodeStack.isEmpty() ? null : this.nodeStack.peek();
    }

    public void pushNode(Node node) {
        if (this.nodeStack.isEmpty()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Pushing top level node: " + node + " for txn: " + this.businessTransaction);
            }
            this.businessTransaction.getNodes().add(node);
        } else {
            Node parent = this.nodeStack.peek();
            if (parent instanceof ContainerNode) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Add node: " + node + " to parent: " + parent + " in txn: " + this.businessTransaction);
                }
                ((ContainerNode)parent).getNodes().add(node);
            } else {
                log.severe("Attempt to add node '" + node + "' under non-container node '" + parent + "'");
            }
        }
        this.nodeStack.push(node);
    }

    public Node popNode() {
        return this.nodeStack.pop();
    }

    public void retainNode(String id) {
        Node current = this.getCurrentNode();
        if (current != null) {
            this.retainedNodes.put(id, current);
        }
    }

    public void releaseNode(String id) {
        this.retainedNodes.remove(id);
    }

    public Node retrieveNode(String id) {
        return this.retainedNodes.get(id);
    }

    public List<String> getUnlinkedIds() {
        return this.unlinkedIds;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("Fragment builder: current btxn=[");
        info.append(this.businessTransaction);
        info.append("] complete=");
        info.append(this.isComplete());
        info.append(" unlinkedIds=");
        info.append(this.getUnlinkedIds());
        return info.toString();
    }
}

