/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BooleanExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class ComparisonExpression
extends BooleanExpression {
    private Type comparisonType = Type.UNDEFINED;
    private boolean comparable = false;

    public ComparisonExpression(Rule rule, int oper, ParseNode token, Expression left, Expression right) {
        super(rule, oper, token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(Type.UNDEFINED);
        Type type2 = this.getOperand(1).typeCheck(Type.UNDEFINED);
        if (type1.isNumeric() || type2.isNumeric()) {
            this.comparisonType = Type.promote(type1, type2);
            this.comparable = true;
        } else if (type1.isAssignableFrom(type2)) {
            this.comparisonType = type1;
            this.comparable = Comparable.class.isAssignableFrom(this.comparisonType.getTargetClass());
        } else if (type2.isAssignableFrom(type1)) {
            this.comparisonType = type2;
            this.comparable = Comparable.class.isAssignableFrom(this.comparisonType.getTargetClass());
        } else {
            throw new TypeException("ComparisonExpression.typeCheck : incomparable argument types " + type1.getName() + " and " + type2.getName() + " for comparison expression" + this.getPos());
        }
        if (this.oper != 8320 && this.oper != 8321 && !this.comparable) {
            throw new TypeException("ComparisonExpression.typeCheck : cannot compare instances of class " + this.comparisonType.getName() + this.getPos());
        }
        this.type = Type.Z;
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("ComparisonExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            Object value2;
            Object value1;
            block63: {
                block65: {
                    boolean result;
                    block64: {
                        if (!this.comparisonType.isNumeric()) break block63;
                        value1 = (Number)this.getOperand(0).interpret(helper);
                        value2 = (Number)this.getOperand(1).interpret(helper);
                        if (this.comparisonType == Type.B) break block64;
                        if (this.comparisonType == Type.S) break block64;
                        if (this.comparisonType != Type.I) break block65;
                    }
                    int i1 = ((Number)value1).intValue();
                    int i2 = ((Number)value2).intValue();
                    switch (this.oper) {
                        case 8323: {
                            result = i1 < i2;
                            break;
                        }
                        case 8325: {
                            result = i1 <= i2;
                            break;
                        }
                        case 8322: {
                            result = i1 > i2;
                            break;
                        }
                        case 8324: {
                            result = i1 >= i2;
                            break;
                        }
                        case 8320: {
                            result = i1 == i2;
                            break;
                        }
                        case 8321: {
                            result = i1 != i2;
                            break;
                        }
                        default: {
                            result = false;
                        }
                    }
                    return result;
                }
                if (this.comparisonType == Type.J) {
                    boolean result;
                    long l1 = ((Number)value1).longValue();
                    long l2 = ((Number)value2).longValue();
                    switch (this.oper) {
                        case 8323: {
                            result = l1 < l2;
                            break;
                        }
                        case 8325: {
                            result = l1 <= l2;
                            break;
                        }
                        case 8322: {
                            result = l1 > l2;
                            break;
                        }
                        case 8324: {
                            result = l1 >= l2;
                            break;
                        }
                        case 8320: {
                            result = l1 == l2;
                            break;
                        }
                        case 8321: {
                            result = l1 != l2;
                            break;
                        }
                        default: {
                            result = false;
                        }
                    }
                    return result;
                }
                if (this.comparisonType == Type.F) {
                    boolean result;
                    float f1 = ((Number)value1).floatValue();
                    float f2 = ((Number)value2).floatValue();
                    switch (this.oper) {
                        case 8323: {
                            result = f1 < f2;
                            break;
                        }
                        case 8325: {
                            result = f1 <= f2;
                            break;
                        }
                        case 8322: {
                            result = f1 > f2;
                            break;
                        }
                        case 8324: {
                            result = f1 >= f2;
                            break;
                        }
                        case 8320: {
                            result = f1 == f2;
                            break;
                        }
                        case 8321: {
                            result = f1 != f2;
                            break;
                        }
                        default: {
                            result = false;
                        }
                    }
                    return result;
                }
                if (this.comparisonType == Type.D) {
                    boolean result;
                    double d1 = ((Number)value1).doubleValue();
                    double d2 = ((Number)value2).doubleValue();
                    switch (this.oper) {
                        case 8323: {
                            result = d1 < d2;
                            break;
                        }
                        case 8325: {
                            result = d1 <= d2;
                            break;
                        }
                        case 8322: {
                            result = d1 > d2;
                            break;
                        }
                        case 8324: {
                            result = d1 >= d2;
                            break;
                        }
                        case 8320: {
                            result = d1 == d2;
                            break;
                        }
                        case 8321: {
                            result = d1 != d2;
                            break;
                        }
                        default: {
                            result = false;
                        }
                    }
                    return result;
                }
                if (this.comparisonType == Type.C) {
                    boolean result;
                    char c1 = (char)((Number)value1).intValue();
                    char c2 = (char)((Number)value2).intValue();
                    switch (this.oper) {
                        case 8323: {
                            result = c1 < c2;
                            break;
                        }
                        case 8325: {
                            result = c1 <= c2;
                            break;
                        }
                        case 8322: {
                            result = c1 > c2;
                            break;
                        }
                        case 8324: {
                            result = c1 >= c2;
                            break;
                        }
                        case 8320: {
                            result = c1 == c2;
                            break;
                        }
                        case 8321: {
                            result = c1 != c2;
                            break;
                        }
                        default: {
                            result = false;
                        }
                    }
                    return result;
                }
            }
            if (this.comparable) {
                boolean result;
                value1 = (Comparable)this.getOperand(0).interpret(helper);
                value2 = (Comparable)this.getOperand(1).interpret(helper);
                if (value1 == null || value2 == null) {
                    if (this.oper == 8320) {
                        return value1 == value2;
                    }
                    if (this.oper == 8321) {
                        return value1 != value2;
                    }
                    return false;
                }
                int cmp = value1.compareTo(value2);
                switch (this.oper) {
                    case 8323: {
                        cmp = value1.compareTo(value2);
                        result = cmp < 0;
                        break;
                    }
                    case 8325: {
                        cmp = value1.compareTo(value2);
                        result = cmp <= 0;
                        break;
                    }
                    case 8322: {
                        cmp = value1.compareTo(value2);
                        result = cmp > 0;
                        break;
                    }
                    case 8324: {
                        cmp = value1.compareTo(value2);
                        result = cmp >= 0;
                        break;
                    }
                    case 8320: {
                        result = value1.equals(value2);
                        break;
                    }
                    case 8321: {
                        result = !value1.equals(value2);
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                return result;
            }
            if (this.comparisonType == Type.Z || this.comparisonType == Type.BOOLEAN) {
                value1 = (Boolean)this.getOperand(0).interpret(helper);
                value2 = (Boolean)this.getOperand(1).interpret(helper);
                boolean result = this.oper == 8320 ? ((Boolean)value1).equals(value2) : !((Boolean)value1).equals(value2);
                return result;
            }
            value1 = this.getOperand(0).interpret(helper);
            value2 = this.getOperand(1).interpret(helper);
            boolean result = this.oper == 8320 ? value1 == value2 : value1 != value2;
            return result;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("ComparisonExpression.interpret : unexpected exception for operation " + this.token + this.getPos() + " in rule " + helper.getName(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        block49: {
            block48: {
                block47: {
                    compileContext.notifySourceLine(this.line);
                    oper0 = this.getOperand(0);
                    oper1 = this.getOperand(1);
                    removed = 0;
                    oper0.compile(mv, compileContext);
                    this.compileTypeConversion(oper0.getType(), this.comparisonType, mv, compileContext);
                    oper1.compile(mv, compileContext);
                    this.compileTypeConversion(oper1.getType(), this.comparisonType, mv, compileContext);
                    if (this.comparisonType == Type.B) break block47;
                    if (this.comparisonType == Type.S) break block47;
                    if (this.comparisonType == Type.S) break block47;
                    if (this.comparisonType != Type.I) break block48;
                }
                elsetarget = new Label();
                endtarget = new Label();
                removed = 2;
                switch (this.oper) {
                    case 8323: {
                        mv.visitJumpInsn(162, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8325: {
                        mv.visitJumpInsn(163, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8322: {
                        mv.visitJumpInsn(164, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8324: {
                        mv.visitJumpInsn(161, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8320: {
                        mv.visitJumpInsn(160, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8321: {
                        mv.visitJumpInsn(159, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                    }
                }
                break block49;
            }
            if (this.comparisonType == Type.J) ** GOTO lbl77
            if (this.comparisonType == Type.F) ** GOTO lbl77
            if (this.comparisonType == Type.D) {
lbl77:
                // 3 sources

                if (this.comparisonType == Type.J) {
                    mv.visitInsn(148);
                    removed = 4;
                } else if (this.comparisonType == Type.F) {
                    removed = 2;
                    mv.visitInsn(150);
                } else if (this.comparisonType == Type.D) {
                    removed = 4;
                    mv.visitInsn(152);
                }
                elsetarget = new Label();
                endtarget = new Label();
                switch (this.oper) {
                    case 8323: {
                        mv.visitJumpInsn(156, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8325: {
                        mv.visitJumpInsn(157, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8322: {
                        mv.visitJumpInsn(158, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8324: {
                        mv.visitJumpInsn(155, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8320: {
                        mv.visitJumpInsn(154, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8321: {
                        mv.visitJumpInsn(153, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                    }
                }
            } else if (this.comparable) {
                removed = 4;
                compileContext.addStackCount(2);
                splittarget = new Label();
                jointarget = new Label();
                mv.visitInsn(92);
                mv.visitInsn(87);
                mv.visitJumpInsn(198, splittarget);
                mv.visitInsn(89);
                mv.visitJumpInsn(198, splittarget);
                if (this.oper != 8320 && this.oper != 8321) {
                    mv.visitMethodInsn(185, "java/lang/Comparable", "compareTo", "(Ljava/lang/Object;)I");
                } else {
                    mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
                }
                elsetarget = new Label();
                endtarget = new Label();
                switch (this.oper) {
                    case 8323: {
                        mv.visitJumpInsn(156, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8325: {
                        mv.visitJumpInsn(157, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8322: {
                        mv.visitJumpInsn(158, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8324: {
                        mv.visitJumpInsn(155, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        break;
                    }
                    case 8321: {
                        mv.visitJumpInsn(153, elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitLabel(endtarget);
                    }
                }
                mv.visitJumpInsn(167, jointarget);
                mv.visitLabel(splittarget);
                if (this.oper == 8320) {
                    elsetarget = new Label();
                    endtarget = new Label();
                    mv.visitJumpInsn(165, elsetarget);
                    mv.visitLdcInsn(false);
                    mv.visitJumpInsn(167, endtarget);
                    mv.visitLabel(elsetarget);
                    mv.visitLdcInsn(true);
                    mv.visitLabel(endtarget);
                } else if (this.oper == 8321) {
                    elsetarget = new Label();
                    endtarget = new Label();
                    mv.visitJumpInsn(166, elsetarget);
                    mv.visitLdcInsn(false);
                    mv.visitJumpInsn(167, endtarget);
                    mv.visitLabel(elsetarget);
                    mv.visitLdcInsn(true);
                    mv.visitLabel(endtarget);
                } else {
                    mv.visitInsn(88);
                    mv.visitLdcInsn(false);
                }
                mv.visitLabel(jointarget);
            } else if (this.comparisonType == Type.Z) {
                removed = 2;
                elsetarget = new Label();
                endtarget = new Label();
                mv.visitJumpInsn(153, elsetarget);
                if (this.oper == 8321) {
                    elsetarget2 = new Label();
                    mv.visitJumpInsn(153, elsetarget2);
                    mv.visitLdcInsn(false);
                    mv.visitJumpInsn(167, endtarget);
                    mv.visitLabel(elsetarget2);
                    mv.visitLdcInsn(true);
                }
                mv.visitJumpInsn(167, endtarget);
                mv.visitLabel(elsetarget);
                if (this.oper == 8320) {
                    elsetarget2 = new Label();
                    mv.visitJumpInsn(153, elsetarget2);
                    mv.visitLdcInsn(false);
                    mv.visitJumpInsn(167, endtarget);
                    mv.visitLabel(elsetarget2);
                    mv.visitLdcInsn(true);
                }
                mv.visitLabel(endtarget);
            } else if (this.comparisonType == Type.BOOLEAN) {
                removed = 2;
                elsetarget = new Label();
                endtarget = new Label();
                mv.visitMethodInsn(182, "java.lang.Boolean", "equals", "(Ljava/lang/Boolean;)Z");
                if (this.oper == 8321) {
                    mv.visitJumpInsn(153, elsetarget);
                    mv.visitLdcInsn(true);
                    mv.visitJumpInsn(167, endtarget);
                    mv.visitLabel(elsetarget);
                    mv.visitLdcInsn(false);
                    mv.visitLabel(endtarget);
                }
            } else {
                removed = 2;
                elsetarget = new Label();
                endtarget = new Label();
                if (this.oper == 8320) {
                    mv.visitJumpInsn(166, elsetarget);
                    mv.visitLdcInsn(true);
                    mv.visitJumpInsn(167, endtarget);
                    mv.visitLabel(elsetarget);
                    mv.visitLdcInsn(false);
                    mv.visitLabel(endtarget);
                } else {
                    mv.visitJumpInsn(165, elsetarget);
                    mv.visitLdcInsn(true);
                    mv.visitJumpInsn(167, endtarget);
                    mv.visitLabel(elsetarget);
                    mv.visitLdcInsn(false);
                    mv.visitLabel(endtarget);
                }
            }
        }
        compileContext.addStackCount(1 - removed);
    }
}

