/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal.helpers;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.hawkular.btm.api.logging.Logger;
import org.w3c.dom.Node;

public class XMLHelper {
    private static final Logger log = Logger.getLogger(XMLHelper.class.getName());
    private static final String DEFAULT_INDENT = "yes";
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static String serialize(Object node) {
        if (node instanceof String) {
            return (String)node;
        }
        if (node instanceof DOMSource) {
            return XMLHelper.serializeDOMSource((DOMSource)node);
        }
        if (node instanceof Node) {
            return XMLHelper.serializeNode((Node)node);
        }
        log.severe("Unable to serialize '" + node + "'");
        return null;
    }

    public static String serializeNode(Node node) {
        return XMLHelper.serializeDOMSource(new DOMSource(node));
    }

    public static String serializeDOMSource(DOMSource domSource) {
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", DEFAULT_ENCODING);
            transformer.setOutputProperty("indent", DEFAULT_INDENT);
            transformer.transform(domSource, result);
            writer.flush();
            return writer.toString();
        }
        catch (Throwable e) {
            log.log(Logger.Level.SEVERE, "Failed to serialize node", e);
            return null;
        }
    }

    public static String evaluate(String xpath, Object node) {
        Node domNode = XMLHelper.getNode(node);
        if (domNode == null) {
            log.severe("Unable to evaluate non DOM Node object");
            return null;
        }
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            return xp.evaluate(xpath, domNode);
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to evaluate xpath '" + xpath + "'", e);
            return null;
        }
    }

    protected static Node getNode(Object node) {
        if (node instanceof Node) {
            return (Node)node;
        }
        if (node instanceof DOMSource) {
            return ((DOMSource)node).getNode();
        }
        log.severe("Cannot convert '" + node + "' to DOM node");
        return null;
    }
}

